/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.AbstractQuery;
import com.github.braisdom.objsql.ConnectionFactory;
import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.relation.Relationship;
import com.github.braisdom.objsql.relation.RelationshipNetwork;
import com.github.braisdom.objsql.util.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class DefaultQuery<T>
extends AbstractQuery<T> {
    private static final String SELECT_STATEMENT = "SELECT %s FROM %s";

    public DefaultQuery(Class<T> domainModelClass) {
        super(domainModelClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> execute(Relationship ... relationships) throws SQLException {
        ConnectionFactory connectionFactory = Databases.getConnectionFactory();
        try (Connection connection = connectionFactory.getConnection();){
            String tableName = this.domainModelDescriptor.getTableName();
            String sql = this.createQuerySQL(tableName, this.projection, this.filter, this.groupBy, this.having, this.orderBy, this.offset, this.limit);
            List rows = this.executeInternally(connection, sql);
            if (relationships.length > 0) {
                new RelationshipNetwork(connection, this.domainModelDescriptor).process(rows, relationships);
            }
            List list = rows;
            return list;
        }
    }

    @Override
    public T queryFirst(Relationship ... relationships) throws SQLException {
        List<T> results = this.execute(relationships);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public <C extends Class> List<C> execute(C relevantDomainClass, Relationship ... relationships) throws SQLException {
        String sql = this.createQuerySQL(this.getTableName(relevantDomainClass), this.projection, this.filter, this.groupBy, this.having, this.orderBy, this.offset, this.limit);
        return null;
    }

    private String createQuerySQL(String tableName, String projections, String filter, String groupBy, String having, String orderBy, int offset, int limit) {
        Objects.requireNonNull(tableName, "The tableName cannot be null");
        StringBuilder sql = new StringBuilder();
        projections = projections == null || projections.length() < 0 ? "*" : projections;
        String standardSql = String.format(SELECT_STATEMENT, projections, tableName);
        sql.append(standardSql);
        if (!StringUtil.isBlank(filter)) {
            sql.append(" WHERE ").append(filter);
        }
        if (!StringUtil.isBlank(groupBy)) {
            sql.append(" GROUP BY ").append(groupBy);
        }
        if (!StringUtil.isBlank(having)) {
            sql.append(" HAVING ").append(having);
        }
        if (!StringUtil.isBlank(orderBy)) {
            sql.append(" ORDER BY ").append(orderBy);
        }
        if (offset > 0) {
            sql.append(" OFFSET ").append(offset);
        }
        if (limit > 0) {
            sql.append(" LIMIT ").append(limit);
        }
        return sql.toString();
    }
}

