/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.AbstractResultSetHandler;
import com.github.braisdom.objsql.DomainModelDescriptor;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.transition.ColumnTransitional;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class DomainModelHandler
extends AbstractResultSetHandler<Object> {
    private final DomainModelDescriptor domainModelDescriptor;
    private final DatabaseMetaData databaseMetaData;

    public DomainModelHandler(DomainModelDescriptor domainModelDescriptor, DatabaseMetaData databaseMetaData) {
        this.domainModelDescriptor = domainModelDescriptor;
        this.databaseMetaData = databaseMetaData;
    }

    @Override
    public Object handle(ResultSet rs) throws SQLException {
        Object bean = this.domainModelDescriptor.newInstance();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i);
            if (columnName.equalsIgnoreCase("last_insert_rowid()")) {
                PrimaryKey primaryKey = this.domainModelDescriptor.getPrimaryKey();
                String primaryFieldName = this.domainModelDescriptor.getFieldName(primaryKey.name());
                this.domainModelDescriptor.setValue(bean, primaryFieldName, rs.getObject(columnName));
                continue;
            }
            String fieldName = this.domainModelDescriptor.getFieldName(columnName);
            Class fieldType = this.domainModelDescriptor.getFieldType(fieldName);
            ColumnTransitional columnTransitional = this.domainModelDescriptor.getColumnTransition(fieldName);
            if (fieldName != null) {
                Object rawValue = this.getValue(fieldType, rs.getObject(columnName));
                Object value = columnTransitional == null ? rawValue : columnTransitional.rising(this.databaseMetaData, metaData, bean, this.domainModelDescriptor, fieldName, rawValue);
                this.domainModelDescriptor.setValue(bean, fieldName, value);
                continue;
            }
            PropertyUtils.writeRawAttribute(bean, columnName, rs.getObject(columnName));
        }
        return bean;
    }
}

