/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql;

import com.github.braisdom.objsql.Logger;
import com.github.braisdom.objsql.util.StringUtil;
import java.util.Arrays;
import java.util.logging.Level;

class LoggerImpl
implements Logger {
    private final Class<?> clazz;
    private final java.util.logging.Logger logger;

    public LoggerImpl(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = java.util.logging.Logger.getLogger(clazz.getName());
    }

    @Override
    public void info(long elapsedTime, String sql, Object[] params) {
        CharSequence[] paramStrings = (String[])Arrays.stream(params).map(param -> String.valueOf(param)).toArray(String[]::new);
        String paramString = String.join((CharSequence)",", paramStrings);
        String log = String.format("[%dms] %s, with: [%s]", elapsedTime, sql, String.join((CharSequence)",", paramString.length() > 100 ? StringUtil.truncate(paramString, 99) : paramString));
        this.logger.logp(Level.INFO, this.clazz.getName(), "", log);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.logger.throwing(this.clazz.getName(), "unknown", throwable);
    }
}

