/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.Databases;
import com.github.braisdom.objsql.Persistence;
import com.github.braisdom.objsql.PersistenceFactory;
import com.github.braisdom.objsql.Query;
import com.github.braisdom.objsql.QueryFactory;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.ValidationException;
import com.github.braisdom.objsql.Validator;
import com.github.braisdom.objsql.annotations.DomainModel;
import com.github.braisdom.objsql.annotations.PrimaryKey;
import com.github.braisdom.objsql.annotations.Transient;
import com.github.braisdom.objsql.apt.APTBuilder;
import com.github.braisdom.objsql.apt.AnnotationValues;
import com.github.braisdom.objsql.apt.DomainModelProcessor;
import com.github.braisdom.objsql.apt.MethodBuilder;
import com.github.braisdom.objsql.apt.StatementBuilder;
import com.github.braisdom.objsql.reflection.ClassUtils;
import com.github.braisdom.objsql.reflection.PropertyUtils;
import com.github.braisdom.objsql.relation.Relationship;
import com.github.braisdom.objsql.sql.AbstractTable;
import com.github.braisdom.objsql.sql.Column;
import com.github.braisdom.objsql.sql.DefaultColumn;
import com.github.braisdom.objsql.sql.Select;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.lang.annotation.Annotation;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DomainModelCodeGenerator
extends DomainModelProcessor {
    @Override
    public void handle(AnnotationValues annotationValues, JCTree ast, APTBuilder aptBuilder) {
        this.handleSetterGetter(annotationValues, aptBuilder);
        this.handlePrimary(annotationValues, aptBuilder);
        this.handleTableName(aptBuilder);
        this.handleCreateQueryMethod(aptBuilder);
        this.handleCreateSelectMethod(aptBuilder);
        this.handleCreatePersistenceMethod(aptBuilder);
        this.handleSaveMethod(aptBuilder);
        this.handleCreateMethod(aptBuilder);
        this.handleCreateArrayMethod(aptBuilder);
        this.handleUpdateMethod(annotationValues, aptBuilder);
        this.handleUpdate2Method(aptBuilder);
        this.handleDestroyMethod(annotationValues, aptBuilder);
        this.handleDestroy2Method(aptBuilder);
        this.handleExecuteMethod(aptBuilder);
        this.handleQueryMethod(aptBuilder);
        this.handleQuery2Method(aptBuilder);
        this.handleQuery3Method(aptBuilder);
        this.handleQueryFirstMethod(aptBuilder);
        this.handleQueryFirst2Method(aptBuilder);
        this.handleQueryAllMethod(aptBuilder);
        this.handleCountMethod(aptBuilder);
        this.handleValidateMethod(aptBuilder);
        this.handleNewInstanceFromMethod(aptBuilder);
        this.handleRawAttributesField(aptBuilder);
        this.handleInnerTableClass(aptBuilder);
    }

    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return DomainModel.class;
    }

    private void handleSetterGetter(AnnotationValues annotationValues, APTBuilder aptBuilder) {
        JCTree.JCVariableDecl[] fields = aptBuilder.getFields();
        DomainModel domainModel = annotationValues.getAnnotationValue(DomainModel.class);
        aptBuilder.getTreeMaker().at(aptBuilder.get().pos);
        for (JCTree.JCVariableDecl field : fields) {
            if (aptBuilder.isStatic(field.mods)) continue;
            JCTree.JCMethodDecl setter = aptBuilder.newSetter(field, domainModel.fluent());
            JCTree.JCMethodDecl getter = aptBuilder.newGetter(field);
            aptBuilder.inject(setter);
            aptBuilder.inject(getter);
        }
    }

    private void handlePrimary(AnnotationValues annotationValues, APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        DomainModel domainModel = annotationValues.getAnnotationValue(DomainModel.class);
        JCTree.JCAnnotation annotation = treeMaker.Annotation(aptBuilder.typeRef(PrimaryKey.class), List.of(treeMaker.Assign(treeMaker.Ident(aptBuilder.toName("name")), treeMaker.Literal(domainModel.primaryColumnName()))));
        JCTree.JCModifiers modifiers = treeMaker.Modifiers(2L);
        modifiers.annotations = modifiers.annotations.append(annotation);
        JCTree.JCVariableDecl primaryField = treeMaker.VarDef(modifiers, aptBuilder.toName(domainModel.primaryFieldName()), aptBuilder.typeRef(domainModel.primaryClass()), null);
        JCTree.JCMethodDecl queryByPrimaryKey = this.createQueryByPrimaryKeyMethod(domainModel, primaryField, aptBuilder);
        aptBuilder.inject(primaryField);
        aptBuilder.inject(queryByPrimaryKey);
        aptBuilder.inject(aptBuilder.newSetter(primaryField, domainModel.fluent()));
        aptBuilder.inject(aptBuilder.newGetter(primaryField));
    }

    private JCTree.JCMethodDecl createQueryByPrimaryKeyMethod(DomainModel domainModel, JCTree.JCVariableDecl primaryField, APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(treeMaker.Literal(String.format("%s = ?", domainModel.primaryColumnName())), aptBuilder.varRef("primaryKey")));
        methodBuilder.setReturnStatement("query", "queryFirst", new JCTree.JCExpression[0]);
        return methodBuilder.addStatements(statementBuilder.build()).addParameter("primaryKey", primaryField.vartype).setThrowsClauses(SQLException.class).setReturnType(aptBuilder.typeRef(aptBuilder.getClassName())).build("queryByPrimaryKey", 25);
    }

    private void handleTableName(APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        JCTree.JCModifiers modifiers = treeMaker.Modifiers(25L);
        JCTree.JCMethodInvocation methodInvocation = treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(Tables.class), aptBuilder.toName("getTableName")), List.of(aptBuilder.classRef(aptBuilder.getClassName())));
        JCTree.JCVariableDecl tableNameField = treeMaker.VarDef(modifiers, aptBuilder.toName("TABLE_NAME"), aptBuilder.typeRef(String.class), methodInvocation);
        aptBuilder.inject(tableNameField);
    }

    private void handleCreateQueryMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.typeRef(QueryFactory.class), "queryFactory", Databases.class, "getQueryFactory", List.nil());
        methodBuilder.setReturnStatement("queryFactory", "createQuery", aptBuilder.classRef(aptBuilder.getClassName()));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).setReturnType(Query.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("createQuery", 25));
    }

    private void handleCreateSelectMethod(APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        methodBuilder.setReturnStatement(treeMaker.NewClass(null, List.nil(), aptBuilder.typeRef(Select.class), List.of(aptBuilder.methodCall("asTable", new JCTree.JCExpression[0])), null));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).setReturnType(Select.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("createSelect", 25));
    }

    private void handleCreatePersistenceMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.typeRef(PersistenceFactory.class), "persistenceFactory", Databases.class, "getPersistenceFactory", List.nil());
        methodBuilder.setReturnStatement("persistenceFactory", "createPersistence", aptBuilder.classRef(aptBuilder.getClassName()));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).setReturnType(Persistence.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("createPersistence", 25));
    }

    private void handleSaveMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        statementBuilder.append("persistence", "save", aptBuilder.varRef("this"), aptBuilder.varRef("skipValidation"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("skipValidation", (JCTree.JCExpression)treeMaker.TypeIdent(TypeTag.BOOLEAN)).setThrowsClauses(SQLException.class).build("save", 17));
    }

    private void handleCreateMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "insert", aptBuilder.varRef("dirtyObject"), aptBuilder.varRef("skipValidation"));
        aptBuilder.inject(methodBuilder.setReturnType(aptBuilder.typeRef(aptBuilder.getClassName())).addStatements(statementBuilder.build()).addParameter("dirtyObject", aptBuilder.typeRef(aptBuilder.getClassName())).addParameter("skipValidation", (JCTree.JCExpression)treeMaker.TypeIdent(TypeTag.BOOLEAN)).setThrowsClauses(SQLException.class).build("create", 25));
    }

    private void handleCreateArrayMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "insert", aptBuilder.varRef("dirtyObjects"), aptBuilder.varRef("skipValidation"));
        aptBuilder.inject(methodBuilder.setReturnType(aptBuilder.newArrayType(treeMaker.TypeIdent(TypeTag.INT))).addStatements(statementBuilder.build()).addParameter("dirtyObjects", aptBuilder.newArrayType(aptBuilder.getClassName())).addParameter("skipValidation", (JCTree.JCExpression)treeMaker.TypeIdent(TypeTag.BOOLEAN)).setThrowsClauses(SQLException.class).build("create", 25));
    }

    private void handleUpdateMethod(AnnotationValues annotationValues, APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        DomainModel domainModel = annotationValues.getAnnotationValue(DomainModel.class);
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "update", aptBuilder.varRef("id"), aptBuilder.varRef("dirtyObject"), aptBuilder.varRef("skipValidation"));
        aptBuilder.inject(methodBuilder.setReturnType(treeMaker.TypeIdent(TypeTag.INT)).addStatements(statementBuilder.build()).addParameter("id", aptBuilder.typeRef(domainModel.primaryClass())).addParameter("dirtyObject", aptBuilder.typeRef(aptBuilder.getClassName())).addParameter("skipValidation", (JCTree.JCExpression)treeMaker.TypeIdent(TypeTag.BOOLEAN)).setThrowsClauses(SQLException.class).build("update", 25));
    }

    private void handleUpdate2Method(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "update", aptBuilder.varRef("updates"), aptBuilder.varRef("predicates"));
        aptBuilder.inject(methodBuilder.setReturnType(treeMaker.TypeIdent(TypeTag.INT)).addStatements(statementBuilder.build()).addParameter("updates", aptBuilder.typeRef(String.class)).addParameter("predicates", aptBuilder.typeRef(String.class)).setThrowsClauses(SQLException.class).build("update", 25));
    }

    private void handleDestroyMethod(AnnotationValues annotationValues, APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        DomainModel domainModel = annotationValues.getAnnotationValue(DomainModel.class);
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "delete", aptBuilder.varRef("id"));
        aptBuilder.inject(methodBuilder.setReturnType(treeMaker.TypeIdent(TypeTag.INT)).addStatements(statementBuilder.build()).addParameter("id", aptBuilder.typeRef(domainModel.primaryClass())).setThrowsClauses(SQLException.class).build("destroy", 25));
    }

    private void handleDestroy2Method(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Persistence.class, aptBuilder.getClassName()), "persistence", "createPersistence", new JCTree.JCExpression[0]);
        methodBuilder.setReturnStatement("persistence", "delete", aptBuilder.varRef("predicate"));
        aptBuilder.inject(methodBuilder.setReturnType(treeMaker.TypeIdent(TypeTag.INT)).addStatements(statementBuilder.build()).addParameter("predicate", aptBuilder.typeRef(String.class)).setThrowsClauses(SQLException.class).build("destroy", 25));
    }

    private void handleExecuteMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        methodBuilder.setReturnStatement(Tables.class, "execute", aptBuilder.varRef("sql"), aptBuilder.varRef("params"));
        aptBuilder.inject(methodBuilder.setReturnType(aptBuilder.getTreeMaker().TypeIdent(TypeTag.INT)).addParameter("sql", aptBuilder.typeRef(String.class)).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).build("execute", 25));
    }

    private void handleQueryMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(aptBuilder.varRef("predicate"), aptBuilder.varRef("params")));
        methodBuilder.setReturnStatement("query", "execute", new JCTree.JCExpression[0]);
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("predicate", aptBuilder.typeRef(String.class)).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(java.util.List.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("query", 25));
    }

    private void handleQuery2Method(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(aptBuilder.varRef("predicate"), aptBuilder.varRef("params")));
        methodBuilder.setReturnStatement("query", "execute", aptBuilder.varRef("relations"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("predicate", aptBuilder.typeRef(String.class)).addArrayParameter("relations", Relationship.class).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(java.util.List.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("query", 25));
    }

    private void handleQuery3Method(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        methodBuilder.setReturnStatement(Tables.class, "query", aptBuilder.classRef(aptBuilder.getClassName()), aptBuilder.varRef("sql"), aptBuilder.varRef("params"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("sql", aptBuilder.typeRef(String.class)).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(java.util.List.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("queryBySql", 25));
    }

    private void handleQueryFirstMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(aptBuilder.varRef("predicate"), aptBuilder.varRef("params")));
        methodBuilder.setReturnStatement("query", "queryFirst", aptBuilder.varRef("relations"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("predicate", aptBuilder.typeRef(String.class)).addArrayParameter("relations", Relationship.class).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(aptBuilder.typeRef(aptBuilder.getClassName())).build("queryFirst", 25));
    }

    private void handleQueryFirst2Method(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(aptBuilder.varRef("predicate"), aptBuilder.varRef("params")));
        methodBuilder.setReturnStatement("query", "queryFirst", new JCTree.JCExpression[0]);
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("predicate", aptBuilder.typeRef(String.class)).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(aptBuilder.typeRef(aptBuilder.getClassName())).build("queryFirst", 25));
    }

    private void handleQueryAllMethod(APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        statementBuilder.append(aptBuilder.newGenericsType(Query.class, aptBuilder.getClassName()), "query", "createQuery", new JCTree.JCExpression[0]);
        statementBuilder.append("query", "where", List.of(treeMaker.Literal("")));
        methodBuilder.setReturnStatement("query", "execute", aptBuilder.varRef("relations"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addVarargsParameter("relations", Relationship.class).setThrowsClauses(SQLException.class).setReturnType(java.util.List.class, aptBuilder.typeRef(aptBuilder.getClassName())).build("queryAll", 25));
    }

    private void handleCountMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        methodBuilder.setReturnStatement(Tables.class, "count", aptBuilder.classRef(aptBuilder.getClassName()), aptBuilder.varRef("predicate"), aptBuilder.varRef("params"));
        aptBuilder.inject(methodBuilder.addParameter("predicate", aptBuilder.typeRef(String.class)).addVarargsParameter("params", aptBuilder.typeRef(Object.class)).setThrowsClauses(SQLException.class).setReturnType(aptBuilder.getTreeMaker().TypeIdent(TypeTag.INT)).build("count", 25));
    }

    private void handleValidateMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        JCTree.JCFieldAccess methodRef = treeMaker.Select(aptBuilder.typeRef(Tables.class), aptBuilder.toName("validate"));
        JCTree.JCReturn jcReturn = treeMaker.Return(treeMaker.Apply(List.nil(), methodRef, List.of(aptBuilder.varRef("this"), aptBuilder.getTreeMaker().Literal(true))));
        JCTree.JCCatch jcCatch = treeMaker.Catch(aptBuilder.newVar(ValidationException.class, "ex"), treeMaker.Block(0L, List.of(treeMaker.Return(aptBuilder.methodCall("ex", "getViolations", new JCTree.JCExpression[0])))));
        JCTree.JCTry jcTry = treeMaker.Try(treeMaker.Block(0L, List.of(jcReturn)), List.of(jcCatch), treeMaker.Block(0L, List.nil()));
        aptBuilder.inject(methodBuilder.setReturnType(aptBuilder.newArrayType(Validator.Violation.class)).addStatement(jcTry).build("validate", 17));
    }

    private void handleNewInstanceFromMethod(APTBuilder aptBuilder) {
        MethodBuilder methodBuilder = aptBuilder.createMethodBuilder();
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder statementBuilder = aptBuilder.createStatementBuilder();
        JCTree.JCTypeCast createInstance = treeMaker.TypeCast(aptBuilder.typeRef(aptBuilder.getClassName()), (JCTree.JCExpression)treeMaker.Apply(List.nil(), treeMaker.Select(aptBuilder.typeRef(ClassUtils.class), aptBuilder.toName("createNewInstance")), List.of(aptBuilder.classRef(aptBuilder.getClassName()))));
        statementBuilder.append(aptBuilder.typeRef(aptBuilder.getClassName()), "bean", (JCTree.JCExpression)createInstance);
        statementBuilder.append(PropertyUtils.class, "populate", aptBuilder.varRef("bean"), aptBuilder.varRef("properties"), aptBuilder.varRef("underLine"));
        methodBuilder.setReturnStatement(aptBuilder.varRef("bean"));
        aptBuilder.inject(methodBuilder.addStatements(statementBuilder.build()).addParameter("properties", Map.class).addParameter("underLine", (JCTree.JCExpression)treeMaker.TypeIdent(TypeTag.BOOLEAN)).setReturnType(aptBuilder.typeRef(aptBuilder.getClassName())).build("newInstanceFrom", 25));
    }

    private void handleRawAttributesField(APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        JCTree.JCTypeApply rawAttributesType = treeMaker.TypeApply(aptBuilder.typeRef(Map.class), List.of(aptBuilder.typeRef(String.class), aptBuilder.typeRef(Object.class)));
        JCTree.JCNewClass rawAttributesInit = treeMaker.NewClass(null, List.nil(), aptBuilder.typeRef(HashMap.class.getName()), List.nil(), null);
        JCTree.JCModifiers modifiers = treeMaker.Modifiers(18L);
        modifiers.annotations = modifiers.annotations.append(treeMaker.Annotation(aptBuilder.typeRef(Transient.class), List.nil()));
        aptBuilder.inject(treeMaker.VarDef(modifiers, aptBuilder.toName("rawAttributes"), rawAttributesType, rawAttributesInit));
        MethodBuilder getRawAttributeMethodBuilder = aptBuilder.createMethodBuilder();
        JCTree.JCReturn getRawAttributeReturn = treeMaker.Return(aptBuilder.methodCall("rawAttributes", "get", aptBuilder.varRef("name")));
        aptBuilder.inject(getRawAttributeMethodBuilder.addStatement(getRawAttributeReturn).addParameter("name", String.class).setReturnType(aptBuilder.typeRef(Object.class)).build("getRawAttribute", 17));
        MethodBuilder setRawAttributeMethodBuilder = aptBuilder.createMethodBuilder();
        JCTree.JCMethodInvocation setRawAttributeExpression = aptBuilder.methodCall("rawAttributes", "put", aptBuilder.varRef("name"), aptBuilder.varRef("value"));
        aptBuilder.inject(setRawAttributeMethodBuilder.addStatement(treeMaker.Exec(setRawAttributeExpression)).addParameter("name", String.class).addParameter("value", Object.class).build("setRawAttribute", 17));
        MethodBuilder getRawAttributesMethodBuilder = aptBuilder.createMethodBuilder();
        JCTree.JCReturn getRawAttributesReturn = treeMaker.Return(aptBuilder.varRef("rawAttributes"));
        aptBuilder.inject(getRawAttributesMethodBuilder.addStatement(getRawAttributesReturn).setReturnType(aptBuilder.newGenericsType(Map.class, String.class, Object.class)).build("getRawAttributes", 17));
    }

    private void handleInnerTableClass(APTBuilder aptBuilder) {
        JCTree.JCVariableDecl[] fields;
        JCTree.JCClassDecl classDecl = aptBuilder.classDef(25, "Table", AbstractTable.class);
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        StatementBuilder constructorStatement = aptBuilder.createStatementBuilder();
        StatementBuilder asTableStatement = aptBuilder.createStatementBuilder();
        MethodBuilder asTableMethod = aptBuilder.createMethodBuilder();
        constructorStatement.append("super", aptBuilder.classRef(aptBuilder.getClassName()));
        JCTree.JCMethodDecl constructor = aptBuilder.createConstructor(2, List.nil(), constructorStatement.build());
        classDecl.defs = classDecl.defs.append(constructor);
        asTableMethod.setReturnType(aptBuilder.typeRef(aptBuilder.getClassName() + ".Table"));
        asTableMethod.setReturnStatement(treeMaker.NewClass(null, List.nil(), aptBuilder.typeRef("Table"), List.nil(), null));
        for (JCTree.JCVariableDecl field : fields = aptBuilder.getFields()) {
            if (aptBuilder.isStatic(field.mods)) continue;
            JCTree.JCExpression init = aptBuilder.staticMethodCall(DefaultColumn.class, "create", aptBuilder.classRef(aptBuilder.getClassName()), aptBuilder.varRef("this"), treeMaker.Literal(field.name.toString()));
            JCTree.JCVariableDecl var = aptBuilder.newVar(17, Column.class, field.name.toString(), init);
            classDecl.defs = classDecl.defs.append(var);
        }
        aptBuilder.inject(asTableMethod.build("asTable", 25));
        aptBuilder.inject(classDecl);
    }
}

