/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.apt;

import com.github.braisdom.objsql.annotations.Relation;
import com.github.braisdom.objsql.apt.APTBuilder;
import com.github.braisdom.objsql.apt.AnnotationValues;
import com.github.braisdom.objsql.apt.DomainModelProcessor;
import com.github.braisdom.objsql.relation.RelationType;
import com.github.braisdom.objsql.relation.Relationship;
import com.github.braisdom.objsql.util.WordUtil;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import java.lang.annotation.Annotation;

public class RelationFieldCodeGenerator
extends DomainModelProcessor {
    @Override
    public void handle(AnnotationValues annotationValues, JCTree ast, APTBuilder aptBuilder) {
        Relation relation = annotationValues.getAnnotationValue(Relation.class);
        JCTree.JCVariableDecl relationField = (JCTree.JCVariableDecl)ast;
        if (ast == null || relationField == null) {
            return;
        }
        this.handleRelationField(relation, relationField, aptBuilder);
    }

    @Override
    protected Class<? extends Annotation> getAnnotationClass() {
        return Relation.class;
    }

    private void handleRelationField(Relation relation, JCTree.JCVariableDecl relationField, APTBuilder aptBuilder) {
        TreeMaker treeMaker = aptBuilder.getTreeMaker();
        RelationType relationType = relation.relationType();
        String relationName = String.format("%s_%s", relationType.toString().toUpperCase(), WordUtil.underscore(relationField.getName().toString()).toUpperCase());
        JCTree.JCModifiers modifiers = treeMaker.Modifiers(25L);
        JCTree.JCExpression relationInit = aptBuilder.staticMethodCall(Relationship.class, "createRelation", aptBuilder.classRef(aptBuilder.getClassName()), treeMaker.Literal(relationField.getName().toString()));
        aptBuilder.inject(treeMaker.VarDef(modifiers, aptBuilder.toName(relationName), aptBuilder.typeRef(Relationship.class), relationInit));
    }
}

