/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;

public class ProxyFactory {
    private static final ProxyFactory instance = new ProxyFactory();

    public static ProxyFactory instance() {
        return instance;
    }

    protected ProxyFactory() {
    }

    public <T> T newProxyInstance(Class<T> type, InvocationHandler handler) {
        return type.cast(Proxy.newProxyInstance(handler.getClass().getClassLoader(), new Class[]{type}, handler));
    }

    public CallableStatement createCallableStatement(InvocationHandler handler) {
        return this.newProxyInstance(CallableStatement.class, handler);
    }

    public Connection createConnection(InvocationHandler handler) {
        return this.newProxyInstance(Connection.class, handler);
    }

    public Driver createDriver(InvocationHandler handler) {
        return this.newProxyInstance(Driver.class, handler);
    }

    public PreparedStatement createPreparedStatement(InvocationHandler handler) {
        return this.newProxyInstance(PreparedStatement.class, handler);
    }

    public ResultSet createResultSet(InvocationHandler handler) {
        return this.newProxyInstance(ResultSet.class, handler);
    }

    public ResultSetMetaData createResultSetMetaData(InvocationHandler handler) {
        return this.newProxyInstance(ResultSetMetaData.class, handler);
    }

    public Statement createStatement(InvocationHandler handler) {
        return this.newProxyInstance(Statement.class, handler);
    }
}

