/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql;

import com.github.braisdom.objsql.DatabaseType;
import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.sql.AbstractExpression;
import com.github.braisdom.objsql.sql.Dataset;
import com.github.braisdom.objsql.sql.DefaultExpressionContext;
import com.github.braisdom.objsql.sql.Expression;
import com.github.braisdom.objsql.sql.ExpressionContext;
import com.github.braisdom.objsql.sql.SQLStatementException;
import com.github.braisdom.objsql.sql.Syntax;
import com.github.braisdom.objsql.sql.expression.JoinExpression;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Syntax(value={DatabaseType.All})
public class Select<T>
extends AbstractExpression
implements Dataset {
    protected List<Expression> projections = new ArrayList<Expression>();
    protected Dataset[] fromDatasets;
    protected Expression whereExpression;
    protected List<JoinExpression> joinExpressions;
    protected Expression[] groupByExpressions;
    protected Expression havingExpression;
    protected Expression[] orderByExpressions;
    protected int limit = -1;
    protected int offset = -1;
    protected Dataset[] unionDatasets;
    protected Dataset[] unionAllDatasets;

    public Select() {
    }

    public Select(Dataset dataset) {
        this.from(dataset);
    }

    public Select project(Expression projection, Expression ... projections) {
        this.projections.add(projection);
        if (projections.length > 0) {
            this.projections.addAll(Arrays.asList(projections));
        }
        return this;
    }

    public Select from(Dataset ... datasets) {
        this.fromDatasets = datasets;
        return this;
    }

    public Select where(Expression expression) {
        this.whereExpression = expression;
        return this;
    }

    public Select leftOuterJoin(Dataset dataset, Expression onExpression) {
        this.joinExpressions.add(new JoinExpression(1, dataset, onExpression));
        return this;
    }

    public Select rightOuterJoin(Dataset dataset, Expression onExpression) {
        this.joinExpressions.add(new JoinExpression(2, dataset, onExpression));
        return this;
    }

    public Select innerJoin(Dataset dataset, Expression onExpression) {
        this.joinExpressions.add(new JoinExpression(3, dataset, onExpression));
        return this;
    }

    public Select fullJoin(Dataset dataset, Expression onExpression) {
        this.joinExpressions.add(new JoinExpression(4, dataset, onExpression));
        return this;
    }

    public Select groupBy(Expression ... expressions) {
        this.groupByExpressions = expressions;
        return this;
    }

    public Select having(Expression expression) {
        this.havingExpression = expression;
        return this;
    }

    public Select orderBy(Expression ... expressions) {
        this.orderByExpressions = expressions;
        return this;
    }

    public Select limit(int limit) {
        this.limit = limit;
        return this;
    }

    public Select offset(int offset) {
        this.offset = offset;
        return this;
    }

    public Select union(Dataset ... datasets) {
        this.unionDatasets = datasets;
        return this;
    }

    public Select unionAll(Dataset ... datasets) {
        this.unionAllDatasets = datasets;
        return this;
    }

    public List<T> execute(DatabaseType databaseType, Class<T> domainClass) throws SQLException {
        String sql = this.toSql(new DefaultExpressionContext(databaseType));
        return Tables.query(domainClass, sql, new Object[0]);
    }

    @Override
    public String toSql(ExpressionContext expressionContext) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        this.processProjections(expressionContext, sql);
        this.processFrom(expressionContext, sql);
        this.processWhere(expressionContext, sql);
        this.processJoins(expressionContext, sql);
        this.processGroupBy(expressionContext, sql);
        this.processOrderBy(expressionContext, sql);
        if (this.offset > 0) {
            sql.append(" OFFSET ").append(this.offset);
        }
        if (this.limit > 0) {
            sql.append(" LIMIT ").append(this.limit);
        }
        this.processUnion(expressionContext, sql);
        return sql.toString();
    }

    private void processProjections(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.projections.size() == 0) {
            sql.append(" * ");
        } else {
            CharSequence[] projectionStrings = (String[])this.projections.stream().map(projection -> projection.toSql(expressionContext)).toArray(String[]::new);
            sql.append(String.join((CharSequence)",", projectionStrings));
        }
    }

    private void processFrom(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.fromDatasets != null && this.fromDatasets.length == 0) {
            throw new SQLStatementException("The from cause is required for select statement");
        }
        sql.append(" FROM ");
        CharSequence[] fromStrings = (String[])Arrays.stream(this.fromDatasets).map(dataset -> dataset.toSql(expressionContext)).toArray(String[]::new);
        sql.append(String.join((CharSequence)", ", fromStrings));
    }

    private void processWhere(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.whereExpression != null) {
            sql.append(" WHERE ");
            sql.append(this.whereExpression.toSql(expressionContext));
        }
    }

    private void processJoins(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.joinExpressions != null && this.joinExpressions.size() > 0) {
            CharSequence[] joinStrings = (String[])this.joinExpressions.stream().map(joinExpression -> joinExpression.toSql(expressionContext)).toArray(String[]::new);
            sql.append(String.join((CharSequence)" ", joinStrings));
        }
    }

    private void processGroupBy(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.groupByExpressions != null && this.groupByExpressions.length > 0) {
            sql.append(" GROUP BY ");
            CharSequence[] groupByStrings = (String[])Arrays.stream(this.groupByExpressions).map(groupBy -> groupBy.toSql(expressionContext)).toArray(String[]::new);
            sql.append(String.join((CharSequence)", ", groupByStrings));
            if (this.havingExpression != null) {
                sql.append(" HAVING ");
                sql.append(this.havingExpression.toSql(expressionContext));
            }
        }
    }

    private void processOrderBy(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.orderByExpressions != null && this.orderByExpressions.length > 0) {
            sql.append(" ORDER BY ");
            CharSequence[] orderByStrings = (String[])Arrays.stream(this.orderByExpressions).map(orderBy -> orderBy.toSql(expressionContext)).toArray(String[]::new);
            sql.append(String.join((CharSequence)", ", orderByStrings));
        }
    }

    private void processUnion(ExpressionContext expressionContext, StringBuilder sql) {
        if (this.unionDatasets != null && this.unionDatasets.length > 0) {
            Arrays.stream(this.unionDatasets).forEach(dataset -> sql.append(" UNION ").append(dataset.toSql(expressionContext)).append(" "));
        }
        if (this.unionAllDatasets != null && this.unionAllDatasets.length > 0) {
            Arrays.stream(this.unionAllDatasets).forEach(dataset -> sql.append(" UNION ALL ").append(dataset.toSql(expressionContext)).append(" "));
        }
    }
}

