/*
 * Decompiled with CFR 0.152.
 */
package com.github.brutils.javabrutils;

import com.github.brutils.javabrutils.StringUtil;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NumeroUtil {
    private static final Logger LOGGER = Logger.getLogger(NumeroUtil.class.getName());

    private NumeroUtil() {
    }

    public static boolean isPositivo(Integer numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 positivo.");
        return numero != null && numero > 0;
    }

    public static boolean isPositivo(Long numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 positivo.");
        return numero != null && numero > 0L;
    }

    public static boolean isPositivo(Float numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 positivo.");
        return numero != null && numero.floatValue() > 0.0f;
    }

    public static boolean isPositivo(Double numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 positivo.");
        return numero != null && numero > 0.0;
    }

    public static boolean isPositivo(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 positivo.");
        return numero != null && numero.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean isNegativo(Integer numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 negativo.");
        return numero != null && numero < 0;
    }

    public static boolean isNegativo(Long numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 negativo.");
        return numero != null && numero < 0L;
    }

    public static boolean isNegativo(Float numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 negativo.");
        return numero != null && numero.floatValue() < 0.0f;
    }

    public static boolean isNegativo(Double numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 negativo.");
        return numero != null && numero < 0.0;
    }

    public static boolean isNegativo(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 negativo.");
        return numero != null && numero.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean isVazio(Integer numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 vazio.");
        return numero == null || numero == 0;
    }

    public static boolean isVazio(Long numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 vazio.");
        return numero == null || numero == 0L;
    }

    public static boolean isVazio(Double numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 vazio.");
        return numero == null || Double.doubleToRawLongBits(numero) == 0L;
    }

    public static boolean isVazio(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Verificando se " + numero + " \u00e9 vazio.");
        return numero == null || numero.compareTo(BigDecimal.ZERO) == 0;
    }

    public static Integer nuloParaZero(Integer numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para zero se o valor for nulo.");
        Integer retorno = numero == null ? Integer.valueOf(0) : numero;
        return retorno;
    }

    public static Long nuloParaZero(Long numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para zero se o valor for nulo.");
        Long retorno = numero == null ? Long.valueOf(0L) : numero;
        return retorno;
    }

    public static Float nuloParaZero(Float numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para zero se o valor for nulo.");
        Float retorno = numero == null ? Float.valueOf(0.0f) : numero;
        return retorno;
    }

    public static Double nuloParaZero(Double numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para zero se o valor for nulo.");
        Double retorno = numero == null ? Double.valueOf(0.0) : numero;
        return retorno;
    }

    public static BigDecimal nuloParaZero(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para zero se o valor for nulo.");
        BigDecimal retorno = numero == null ? BigDecimal.ZERO : numero;
        return retorno;
    }

    public static Integer naoPositivoParaNulo(Integer numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for positivo.");
        Integer retorno = NumeroUtil.isPositivo(numero) ? numero : null;
        return retorno;
    }

    public static Long naoPositivoParaNulo(Long numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for positivo.");
        Long retorno = NumeroUtil.isPositivo(numero) ? numero : null;
        return retorno;
    }

    public static Float naoPositivoParaNulo(Float numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for positivo.");
        Float retorno = NumeroUtil.isPositivo(numero) ? numero : null;
        return retorno;
    }

    public static Double naoPositivoParaNulo(Double numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for positivo.");
        Double retorno = NumeroUtil.isPositivo(numero) ? numero : null;
        return retorno;
    }

    public static BigDecimal naoPositivoParaNulo(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for positivo.");
        BigDecimal retorno = NumeroUtil.isPositivo(numero) ? numero : null;
        return retorno;
    }

    public static Integer naoNegativoParaNulo(Integer numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for negativo.");
        Integer retorno = NumeroUtil.isNegativo(numero) ? numero : null;
        return retorno;
    }

    public static Long naoNegativoParaNulo(Long numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for negativo.");
        Long retorno = NumeroUtil.isNegativo(numero) ? numero : null;
        return retorno;
    }

    public static Float naoNegativoParaNulo(Float numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for negativo.");
        Float retorno = NumeroUtil.isNegativo(numero) ? numero : null;
        return retorno;
    }

    public static Double naoNegativoParaNulo(Double numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for negativo.");
        Double retorno = NumeroUtil.isNegativo(numero) ? numero : null;
        return retorno;
    }

    public static BigDecimal naoNegativoParaNulo(BigDecimal numero) {
        LOGGER.log(Level.FINEST, "Convertendo " + numero + " para nulo se n\u00e3o for negativo.");
        BigDecimal retorno = NumeroUtil.isNegativo(numero) ? numero : null;
        return retorno;
    }

    public static BigDecimal converterParaBigDecimal(String string) throws ParseException {
        LOGGER.log(Level.FINEST, "Convertendo a string " + string + " para um n\u00famero do tipo BigDecimal.");
        NumberFormat numberFormat = NumberFormat.getInstance();
        try {
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            return new BigDecimal(numberFormat.parse(StringUtil.nuloParaVazio(string)).toString()).setScale(2, 1);
        }
        catch (ParseException parseException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a string " + string + " para um n\u00famero do tipo BigDecimal");
            throw parseException;
        }
    }

    public static int converterParaInteger(String string) throws NumberFormatException {
        LOGGER.log(Level.FINEST, "Convertendo a string " + string + " para um n\u00famero do tipo int.");
        int resultado = 0;
        try {
            if (!StringUtil.isVazio(string)) {
                resultado = Integer.valueOf(string.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.log(Level.SEVERE, "Erro ao converter a string " + string + " para um n\u00famero do tipo int");
            throw numberFormatException;
        }
        return resultado;
    }
}

