/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;

public final class ObjectMapperFactory {
    private ObjectMapperFactory() {
    }

    private static ObjectMapper getCommonMapper() {
        ObjectMapper commonMapper = new ObjectMapper();
        commonMapper.registerModule((Module)new GuavaModule());
        commonMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        commonMapper.setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE);
        return commonMapper;
    }

    public static ObjectMapper getStrictMapper() {
        ObjectMapper strictMapper = ObjectMapperFactory.getCommonMapper();
        strictMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        strictMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, true);
        strictMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
        return strictMapper;
    }

    public static ObjectMapper getLenientMapper() {
        ObjectMapper lenientMapper = ObjectMapperFactory.getCommonMapper();
        lenientMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        lenientMapper.configure(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES, false);
        lenientMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, false);
        return lenientMapper;
    }
}

