/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.caf.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.CodecException;
import com.hpe.caf.api.DecodeMethod;
import com.hpe.caf.codec.ObjectMapperFactory;
import java.io.IOException;
import java.io.InputStream;

public class JsonCodec
implements Codec {
    private final ObjectMapper strictMapper = ObjectMapperFactory.getStrictMapper();
    private final ObjectMapper lenientMapper = ObjectMapperFactory.getLenientMapper();

    public <T> T deserialise(byte[] data, Class<T> clazz, DecodeMethod method) throws CodecException {
        try {
            return (T)this.getMapper(method).readValue(data, clazz);
        }
        catch (IOException e) {
            throw new CodecException("Failed to deserialise", (Throwable)e);
        }
    }

    public <T> T deserialise(InputStream stream, Class<T> clazz, DecodeMethod method) throws CodecException {
        try {
            return (T)this.getMapper(method).readValue(stream, clazz);
        }
        catch (IOException e) {
            throw new CodecException("Failed to deserialise", (Throwable)e);
        }
    }

    public byte[] serialise(Object object) throws CodecException {
        try {
            return this.getMapper(DecodeMethod.getDefault()).writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new CodecException("Failed to serialise", (Throwable)e);
        }
    }

    protected ObjectMapper getMapper(DecodeMethod method) {
        return method == DecodeMethod.STRICT ? this.strictMapper : this.lenientMapper;
    }
}

