/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.utilities.initialization.boilerplate.BoilerplateInvoker;
import com.github.cafdataprocessing.utilities.initialization.boilerplate.BoilerplateNameResolver;
import com.github.cafdataprocessing.utilities.initialization.boilerplate.CreationResultJson;
import com.google.common.base.Strings;
import com.hpe.caf.boilerplate.webcaller.ApiClient;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoilerplateInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(BoilerplateInitializer.class);

    public static BoilerplateNameResolver initializeBoilerplateIfRequired(String boilerplateApiUrl, String projectId, String boilerplateBaseDataInputFile, String boilerplateBaseDataOutputFile, boolean createBoilerplateBaseData) {
        BoilerplateNameResolver nameResolver;
        if (Strings.isNullOrEmpty((String)boilerplateApiUrl)) {
            LOG.warn("No boilerplate API URL property specified. Will be unable to resolve expression and tag names to IDs unless they are present in base data output file.");
            nameResolver = new BoilerplateNameResolver(null);
        } else {
            ApiClient apiClient = new ApiClient();
            apiClient.setApiKey(projectId);
            apiClient.setBasePath(boilerplateApiUrl);
            nameResolver = new BoilerplateNameResolver(apiClient);
            if (createBoilerplateBaseData) {
                BoilerplateInitializer.initializeBoilerplateBaseData(boilerplateBaseDataInputFile, boilerplateBaseDataOutputFile, boilerplateApiUrl);
            }
        }
        if (!Strings.isNullOrEmpty((String)boilerplateBaseDataOutputFile)) {
            CreationResultJson boilerplateCreationResult = BoilerplateInitializer.loadBoilerplateOutputFile(boilerplateBaseDataOutputFile);
            nameResolver.populateFromCreationResult(boilerplateCreationResult);
        }
        return nameResolver;
    }

    private static void initializeBoilerplateBaseData(String boilerplateBaseDataInputFile, String boilerplateBaseDataOutputFile, String boilerplateApiUrl) {
        BoilerplateInvoker bpInvoker = new BoilerplateInvoker(boilerplateBaseDataInputFile, boilerplateBaseDataOutputFile, boilerplateApiUrl);
        bpInvoker.run();
    }

    private static CreationResultJson loadBoilerplateOutputFile(String boilerplateBaseDataOutputFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (CreationResultJson)mapper.readValue(new File(boilerplateBaseDataOutputFile), CreationResultJson.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to read the output information of created boilerplate expressions and tags.", (Throwable)e);
            return null;
        }
    }
}

