/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.classification.service.client.ApiClient;
import com.github.cafdataprocessing.classification.service.client.ApiException;
import com.github.cafdataprocessing.classification.service.creation.WorkflowCreator;
import com.github.cafdataprocessing.classification.service.creation.created.CreationResult;
import com.github.cafdataprocessing.utilities.initialization.ClassificationWorkflowNameResolver;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ClassificationInitializer.class);

    private static CreationResult initializeClassificationBaseData(String classificationApiUrl, String classificationBaseDataInputFile, String projectId) {
        WorkflowCreator classificationWorkflowCreator = new WorkflowCreator(classificationApiUrl);
        CreationResult creationResult = null;
        try {
            LOG.info("Initializing classification workflow base data.");
            creationResult = classificationWorkflowCreator.createWorkflowFromFile(classificationBaseDataInputFile, projectId);
            LOG.info("Initialized classification workflow base data.");
        }
        catch (ApiException | IOException e) {
            throw new RuntimeException("Failure trying to create classification workflow.", e);
        }
        return creationResult;
    }

    private static void outputClassificationWorkflowCreationResult(CreationResult creationResult, String outputFilename) {
        File outputFile = new File(outputFilename);
        ObjectMapper mapper = new ObjectMapper();
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)creationResult));
        }
        catch (IOException e) {
            LOG.warn("Failed to output information of created classification workflow items.", (Throwable)e);
        }
    }

    private static CreationResult loadClassificationWorkflowOutputFile(String classificationBaseDataOutputFile) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (CreationResult)mapper.readValue(new File(classificationBaseDataOutputFile), CreationResult.class);
        }
        catch (IOException e) {
            LOG.warn("Failed to read the output information of created classification workflow.", (Throwable)e);
            return null;
        }
    }

    public static ClassificationWorkflowNameResolver initializeClassificationWorkflowIfRequired(String classificationApiUrl, boolean createClassificationBaseData, String classificationBaseDataInputFile, String classificationBaseDataOutputFile, String projectId) {
        ClassificationWorkflowNameResolver nameResolver;
        if (Strings.isNullOrEmpty((String)classificationApiUrl)) {
            LOG.warn("No classification API URL property specified. Will be unable to resolve external classification workflow names to IDs unless they are present in base data output file.");
            nameResolver = new ClassificationWorkflowNameResolver(null);
        } else {
            ApiClient apiClient = new ApiClient();
            apiClient.setBasePath(classificationApiUrl);
            nameResolver = new ClassificationWorkflowNameResolver(apiClient);
            if (createClassificationBaseData) {
                CreationResult creationResult = ClassificationInitializer.initializeClassificationBaseData(classificationApiUrl, classificationBaseDataInputFile, projectId);
                nameResolver.populateFromCreationResult(creationResult);
                if (!Strings.isNullOrEmpty((String)classificationBaseDataOutputFile)) {
                    ClassificationInitializer.outputClassificationWorkflowCreationResult(creationResult, classificationBaseDataOutputFile);
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)classificationBaseDataOutputFile)) {
            CreationResult creationResult = ClassificationInitializer.loadClassificationWorkflowOutputFile(classificationBaseDataOutputFile);
            nameResolver.populateFromCreationResult(creationResult);
        }
        return nameResolver;
    }
}

