/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.initialization;

import com.github.cafdataprocessing.classification.service.client.ApiClient;
import com.github.cafdataprocessing.classification.service.client.ApiException;
import com.github.cafdataprocessing.classification.service.client.api.WorkflowsApi;
import com.github.cafdataprocessing.classification.service.client.model.ExistingWorkflow;
import com.github.cafdataprocessing.classification.service.client.model.ExistingWorkflows;
import com.github.cafdataprocessing.classification.service.creation.created.CreatedWorkflow;
import com.github.cafdataprocessing.classification.service.creation.created.CreationResult;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationWorkflowNameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationWorkflowNameResolver.class);
    private final Map<String, Long> namesToIds = new LinkedHashMap<String, Long>();
    private final WorkflowsApi workflowsApi;

    public ClassificationWorkflowNameResolver(ApiClient apiClient) {
        this.workflowsApi = apiClient != null ? new WorkflowsApi(apiClient) : null;
    }

    public void populateFromCreationResult(CreationResult creationResult) {
        if (creationResult == null) {
            return;
        }
        CreatedWorkflow createdWorkflow = creationResult.getWorkflow();
        if (createdWorkflow == null) {
            return;
        }
        this.namesToIds.put(createdWorkflow.getName(), createdWorkflow.getId());
    }

    public void populateWorkflowsFromApiCall(String projectId) throws ApiException {
        int retrievedHitsSize;
        if (this.workflowsApi == null) {
            LOGGER.error("Classification API is not configured for usage, unable to retrieve expressions.");
            return;
        }
        int pageNum = 1;
        int pageSize = 100;
        do {
            ExistingWorkflows workflows = this.workflowsApi.getWorkflows(projectId, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
            ++pageNum;
            retrievedHitsSize = workflows.getWorkflows().size();
            for (ExistingWorkflow workflow : workflows.getWorkflows()) {
                if (this.namesToIds.containsKey(workflow.getName())) continue;
                this.namesToIds.put(workflow.getName(), workflow.getId());
            }
        } while (retrievedHitsSize >= pageSize);
    }

    public Long resolveFromWorkflowName(String workflowName) {
        return this.namesToIds.get(workflowName);
    }
}

