/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.classification.service.client.ApiException;
import com.github.cafdataprocessing.processing.service.client.api.ActionConditionsApi;
import com.github.cafdataprocessing.processing.service.client.api.ActionTypesApi;
import com.github.cafdataprocessing.processing.service.client.api.ActionsApi;
import com.github.cafdataprocessing.processing.service.client.api.ProcessingRulesApi;
import com.github.cafdataprocessing.processing.service.client.api.ProcessingRulesConditionsApi;
import com.github.cafdataprocessing.processing.service.client.api.WorkflowsApi;
import com.github.cafdataprocessing.processing.service.client.model.Action;
import com.github.cafdataprocessing.processing.service.client.model.ExistingAction;
import com.github.cafdataprocessing.processing.service.client.model.ExistingProcessingRule;
import com.github.cafdataprocessing.processing.service.client.model.ExistingWorkflow;
import com.github.cafdataprocessing.utilities.initialization.ActionTypeNameResolver;
import com.github.cafdataprocessing.utilities.initialization.ClassificationWorkflowNameResolver;
import com.github.cafdataprocessing.utilities.initialization.WorkflowCombiner;
import com.github.cafdataprocessing.utilities.initialization.boilerplate.BoilerplateNameResolver;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.ActionJson;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.ProcessingRuleJson;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.WorkflowJson;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.conditions.ConditionJson;
import com.google.common.base.Strings;
import com.hpe.caf.boilerplate.webcaller.ApiClient;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowInitializer.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private final com.github.cafdataprocessing.processing.service.client.ApiClient apiClient = new com.github.cafdataprocessing.processing.service.client.ApiClient();
    private final WorkflowsApi workflowsApi;
    private final ProcessingRulesApi processingRulesApi;
    private final ActionsApi actionsApi;
    private final ActionTypesApi actionTypesApi;
    private final ActionConditionsApi actionConditionsApi;
    private final ProcessingRulesConditionsApi rulesConditionsApi;
    private ActionTypeNameResolver actionTypeNameResolver;
    private final BoilerplateNameResolver boilerplateNameResolver;
    private final ClassificationWorkflowNameResolver classificationWorkflowNameResolver;

    public WorkflowInitializer(String processingApiUrl, BoilerplateNameResolver boilerplateNameResolver, ActionTypeNameResolver actionTypeNameResolver, ClassificationWorkflowNameResolver classificationWorkflowNameResolver) {
        this.apiClient.setBasePath(processingApiUrl);
        this.workflowsApi = new WorkflowsApi(this.apiClient);
        this.processingRulesApi = new ProcessingRulesApi(this.apiClient);
        this.actionsApi = new ActionsApi(this.apiClient);
        this.actionTypesApi = new ActionTypesApi(this.apiClient);
        this.actionConditionsApi = new ActionConditionsApi(this.apiClient);
        this.rulesConditionsApi = new ProcessingRulesConditionsApi(this.apiClient);
        this.actionTypeNameResolver = actionTypeNameResolver;
        this.boilerplateNameResolver = boilerplateNameResolver;
        this.classificationWorkflowNameResolver = classificationWorkflowNameResolver;
    }

    public static WorkflowInitializer createWorkflowInitializer(String processingApiUrl, String boilerplateApiUrl, String classificationApiUrl) {
        ApiClient boilerplateClient = new ApiClient();
        boilerplateClient.setBasePath(boilerplateApiUrl);
        BoilerplateNameResolver boilerplateNameResolver = new BoilerplateNameResolver(boilerplateClient);
        com.github.cafdataprocessing.classification.service.client.ApiClient classificationClient = new com.github.cafdataprocessing.classification.service.client.ApiClient();
        classificationClient.setBasePath(classificationApiUrl);
        ClassificationWorkflowNameResolver classificationWorkflowNameResolver = new ClassificationWorkflowNameResolver(classificationClient);
        return new WorkflowInitializer(processingApiUrl, boilerplateNameResolver, new ActionTypeNameResolver(), classificationWorkflowNameResolver);
    }

    public static WorkflowInitializer createWorkflowOnlyInitializer(String processingApiUrl) {
        return new WorkflowInitializer(processingApiUrl, new BoilerplateNameResolver(null), new ActionTypeNameResolver(), new ClassificationWorkflowNameResolver(null));
    }

    private void retrieveActionTypeInformation(String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        LOGGER.debug("Retrieving action types information for action creation.");
        this.actionTypeNameResolver.populateActionTypesFromApi(this.actionTypesApi, projectId);
        LOGGER.debug("Retrieved action types information for action creation.");
    }

    public long initializeWorkflowBaseData(String inputFileName, String projectId) throws IOException, com.github.cafdataprocessing.processing.service.client.ApiException {
        return this.initializeWorkflowBaseData(inputFileName, null, projectId);
    }

    public long initializeWorkflowBaseData(String inputFileName, String overlayFile, String projectId) throws IOException, com.github.cafdataprocessing.processing.service.client.ApiException {
        WorkflowJson workflowToCreate = this.readInputFile(inputFileName);
        WorkflowJson overlayWorkflow = Strings.isNullOrEmpty((String)overlayFile) ? null : this.readInputFile(overlayFile);
        return this.createWorkflow(workflowToCreate, overlayWorkflow, projectId);
    }

    public long initializeWorkflowBaseData(InputStream workflowBaseDataStream, InputStream workflowOverlayStream, String projectId) throws IOException, com.github.cafdataprocessing.processing.service.client.ApiException {
        WorkflowJson workflowToCreate = this.readInputFile(workflowBaseDataStream);
        WorkflowJson overlayWorkflow = workflowOverlayStream == null ? null : this.readInputFile(workflowOverlayStream);
        return this.createWorkflow(workflowToCreate, overlayWorkflow, projectId);
    }

    public long createWorkflow(WorkflowJson workflow, WorkflowJson workflowOverlay, String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        this.retrieveActionTypeInformation(projectId);
        WorkflowCombiner.combineWorkflows(workflow, workflowOverlay);
        ExistingWorkflow createdWorkflow = this.workflowsApi.createWorkflow(projectId, workflow.toApiBaseWorkflow());
        long createdWorkflowId = createdWorkflow.getId();
        for (ProcessingRuleJson ruleToCreate : workflow.processingRules) {
            this.createProcessingRule(ruleToCreate, createdWorkflowId, projectId);
        }
        return createdWorkflowId;
    }

    private void createProcessingRule(ProcessingRuleJson processingRule, long workflowId, String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        ExistingProcessingRule createdRule = this.processingRulesApi.createRule(projectId, Long.valueOf(workflowId), processingRule.toApiBaseProcessingRule());
        long createdRuleId = createdRule.getId();
        for (ActionJson actionToCreate : processingRule.actions) {
            this.createAction(actionToCreate, workflowId, createdRuleId, projectId);
        }
        for (ConditionJson conditionToCreate : processingRule.ruleConditions) {
            this.createRuleCondition(conditionToCreate, workflowId, createdRuleId, projectId);
        }
    }

    private void createAction(ActionJson actionJson, long workflowId, long ruleId, String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        Action actionToCreate = actionJson.toApiAction(this.actionTypeNameResolver.getActionTypesNamesToIds());
        this.replaceBoilerplateNamesIfRequired(actionToCreate);
        this.replaceClassificationWorkflowNamesIfRequired(actionToCreate, projectId);
        ExistingAction createdAction = null;
        try {
            createdAction = this.actionsApi.createAction(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), actionToCreate);
        }
        catch (com.github.cafdataprocessing.processing.service.client.ApiException e) {
            throw new RuntimeException("Failure trying to create action with name: " + actionToCreate.getName(), e);
        }
        long createdActionId = createdAction.getId();
        for (ConditionJson conditionToCreate : actionJson.actionConditions) {
            this.createActionCondition(conditionToCreate, workflowId, ruleId, createdActionId, projectId);
        }
    }

    private void createActionCondition(ConditionJson conditionJson, long workflowId, long ruleId, long actionId, String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        this.actionConditionsApi.createActionCondition(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), Long.valueOf(actionId), conditionJson.toApiCondition());
    }

    private void createRuleCondition(ConditionJson conditionJson, long workflowId, long ruleId, String projectId) throws com.github.cafdataprocessing.processing.service.client.ApiException {
        this.rulesConditionsApi.createRuleCondition(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), conditionJson.toApiCondition());
    }

    private WorkflowJson readInputFile(String inputFile) throws IOException {
        File baseDataFile = new File(inputFile);
        try {
            return (WorkflowJson)this.mapper.readValue(baseDataFile, WorkflowJson.class);
        }
        catch (IOException e) {
            throw new IOException("Failure trying to deserialize the workflow base data input file. Please check the format of the file contents.", e);
        }
    }

    private WorkflowJson readInputFile(InputStream inputStream) throws IOException {
        try {
            return (WorkflowJson)this.mapper.readValue(inputStream, WorkflowJson.class);
        }
        catch (IOException e) {
            throw new IOException("Failure trying to deserialize the workflow base data input file. Please check the format of the file contents.", e);
        }
    }

    private void replaceBoilerplateNamesIfRequired(Action action) {
        String tagIdKey;
        Object tagIdObj;
        String expressionIdsKey;
        Long actionTypeId = action.getTypeId();
        String actionTypeInternalName = this.actionTypeNameResolver.getActionTypesIdsToNames().get(actionTypeId);
        if (!actionTypeInternalName.equals("BoilerplatePolicyType")) {
            return;
        }
        LinkedHashMap actionSettings = (LinkedHashMap)action.getSettings();
        Object expressionIdsObj = actionSettings.get(expressionIdsKey = "expressionIds");
        if (expressionIdsObj != null) {
            List<Object> updatedExpressionIds = this.boilerplateNameResolver.resolveExpressionIds((ArrayList)expressionIdsObj);
            actionSettings.put(expressionIdsKey, updatedExpressionIds);
        }
        if ((tagIdObj = actionSettings.get(tagIdKey = "tagId")) != null) {
            Object updatedTagId = this.boilerplateNameResolver.resolveTagId(tagIdObj);
            actionSettings.put(tagIdKey, updatedTagId);
        }
    }

    private void replaceClassificationWorkflowNamesIfRequired(Action action, String projectId) {
        String workflowIdKey;
        Long actionTypeId = action.getTypeId();
        String actionTypeInternalName = this.actionTypeNameResolver.getActionTypesIdsToNames().get(actionTypeId);
        if (!actionTypeInternalName.equals("ElasticSearchClassificationPolicyType") && !actionTypeInternalName.equals("ExternalClassificationPolicyType")) {
            return;
        }
        LinkedHashMap actionSettings = (LinkedHashMap)action.getSettings();
        Object workflowIdObj = actionSettings.get(workflowIdKey = "workflowId");
        if (workflowIdObj == null) {
            return;
        }
        Long updatedWorkflowId = this.classificationWorkflowNameResolver.resolveFromWorkflowName((String)workflowIdObj);
        if (updatedWorkflowId == null) {
            LOGGER.debug("Unable to find match for classification workflow name on action. Retrieving classification workflows information from API.");
            try {
                this.classificationWorkflowNameResolver.populateWorkflowsFromApiCall(projectId);
            }
            catch (ApiException e) {
                LOGGER.warn("Unable to retrieve classification workflows information from classification API while creating action.", (Throwable)e);
                return;
            }
            updatedWorkflowId = this.classificationWorkflowNameResolver.resolveFromWorkflowName((String)workflowIdObj);
            if (updatedWorkflowId == null) {
                LOGGER.debug("Unable to resolve the name of classification workflow used on action to an ID. Action name: " + action.getName() + ", if the value specified is a valid ID then the action is still valid.");
                return;
            }
        }
        actionSettings.put(workflowIdKey, updatedWorkflowId);
    }
}

