/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.initialization.jsonobjects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.cafdataprocessing.processing.service.client.model.Action;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.MergeMode;
import com.github.cafdataprocessing.utilities.initialization.jsonobjects.conditions.ConditionJson;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ActionJson {
    public String name;
    public String description;
    public Integer order;
    public LinkedHashMap<String, Object> settings;
    public List<ConditionJson> actionConditions;
    public MergeMode mergeMode;
    public String typeName;
    public Long typeId;

    public ActionJson(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="description") String description, @JsonProperty(value="order") Integer order, @JsonProperty(value="settings") LinkedHashMap<String, Object> settings, @JsonProperty(value="actionConditions") List<ConditionJson> actionConditions, @JsonProperty(value="typeName") String typeName, @JsonProperty(value="typeId") Long typeId, @JsonProperty(value="mergeMode") MergeMode mergeMode) {
        this.name = name;
        this.description = description;
        this.order = order;
        this.settings = settings == null ? new LinkedHashMap() : settings;
        this.actionConditions = actionConditions;
        this.typeId = typeId;
        this.typeName = typeName;
        this.mergeMode = mergeMode == null ? MergeMode.MERGE : mergeMode;
    }

    public Action toApiAction(Map<String, Long> typeNamesToIds) {
        Action action = new Action();
        action.setName(this.name);
        action.setDescription(this.description);
        action.setOrder(this.order);
        action.setSettings(this.settings);
        if (this.typeId != null) {
            action.setTypeId(this.typeId);
            return action;
        }
        if (typeNamesToIds != null && !typeNamesToIds.containsKey(this.typeName)) {
            action.setTypeId(null);
        } else {
            action.setTypeId(typeNamesToIds.get(this.typeName));
        }
        return action;
    }
}

