/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization;

import com.github.cafdataprocessing.processing.service.client.ApiException;
import com.github.cafdataprocessing.processing.service.client.api.ActionTypesApi;
import com.github.cafdataprocessing.processing.service.client.model.ExistingActionType;
import com.github.cafdataprocessing.processing.service.client.model.ExistingActionTypes;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ActionTypeNameResolver {
    private final Map<String, Long> actionTypesNamesToIds = new LinkedHashMap<String, Long>();
    private final Map<Long, String> actionTypesIdsToNames = new LinkedHashMap<Long, String>();
    private static final int pageSize = 100;

    public void populateActionTypesFromApi(ActionTypesApi actionTypesApi, String projectId) throws ApiException {
        ExistingActionTypes actionTypesResult;
        int totalHits;
        int pageNum = 1;
        do {
            actionTypesResult = actionTypesApi.getActionTypes(projectId, Integer.valueOf(pageNum), Integer.valueOf(100));
            List actionTypes = actionTypesResult.getActionTypes();
            for (ExistingActionType actionType : actionTypes) {
                if (!this.actionTypesNamesToIds.containsKey(actionType.getInternalName())) {
                    this.actionTypesNamesToIds.put(actionType.getInternalName(), actionType.getId());
                }
                if (this.actionTypesIdsToNames.containsKey(actionType.getId())) continue;
                this.actionTypesIdsToNames.put(actionType.getId(), actionType.getInternalName());
            }
        } while ((totalHits = actionTypesResult.getTotalHits().intValue()) > ++pageNum * 100);
    }

    public Map<String, Long> getActionTypesNamesToIds() {
        return this.actionTypesNamesToIds;
    }

    public Map<Long, String> getActionTypesIdsToNames() {
        return this.actionTypesIdsToNames;
    }
}

