/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization;

import com.github.cafdataprocessing.initialization.jsonobjects.ActionJson;
import com.github.cafdataprocessing.initialization.jsonobjects.MergeMode;
import com.github.cafdataprocessing.initialization.jsonobjects.ProcessingRuleJson;
import com.github.cafdataprocessing.initialization.jsonobjects.WorkflowJson;
import com.github.cafdataprocessing.initialization.jsonobjects.conditions.ConditionAdditionalJson;
import com.github.cafdataprocessing.initialization.jsonobjects.conditions.ConditionJson;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WorkflowCombiner {
    public static void combineWorkflows(WorkflowJson targetOriginalWorkflow, WorkflowJson overlayWorkflow) {
        Objects.requireNonNull(targetOriginalWorkflow);
        if (overlayWorkflow == null) {
            return;
        }
        for (ProcessingRuleJson overlayProcessingRule : overlayWorkflow.processingRules) {
            Optional<ProcessingRuleJson> baseWorkflowProcessingRule = targetOriginalWorkflow.processingRules.stream().filter(rule -> rule.name.equals(processingRuleJson.name)).findFirst();
            if (baseWorkflowProcessingRule.isPresent()) {
                WorkflowCombiner.combineProcessingRule(baseWorkflowProcessingRule.get(), overlayProcessingRule);
                continue;
            }
            targetOriginalWorkflow.processingRules.add(overlayProcessingRule);
        }
    }

    private static void combineProcessingRule(ProcessingRuleJson processingRule, ProcessingRuleJson overlayProcessingRule) {
        if (overlayProcessingRule.mergeMode == MergeMode.REPLACE) {
            processingRule.enabled = overlayProcessingRule.enabled;
            processingRule.priority = overlayProcessingRule.priority;
            processingRule.description = overlayProcessingRule.description;
            processingRule.actions = overlayProcessingRule.actions;
            processingRule.ruleConditions = overlayProcessingRule.ruleConditions;
        }
        if (overlayProcessingRule.enabled != null) {
            processingRule.enabled = overlayProcessingRule.enabled;
        }
        if (overlayProcessingRule.priority != null) {
            processingRule.priority = overlayProcessingRule.priority;
        }
        if (!Strings.isNullOrEmpty((String)overlayProcessingRule.description)) {
            processingRule.description = overlayProcessingRule.description;
        }
        if (overlayProcessingRule.actions != null) {
            for (ActionJson overlayAction : overlayProcessingRule.actions) {
                Optional<ActionJson> actionJson = processingRule.actions.stream().filter(action -> action.name.equals(actionJson.name)).findFirst();
                if (actionJson.isPresent()) {
                    WorkflowCombiner.combineAction(actionJson.get(), overlayAction);
                    continue;
                }
                processingRule.actions.add(overlayAction);
            }
        }
        if (overlayProcessingRule.ruleConditions != null) {
            if (processingRule.ruleConditions == null) {
                processingRule.ruleConditions = overlayProcessingRule.ruleConditions;
            } else {
                for (ConditionJson overlayActionCondition : overlayProcessingRule.ruleConditions) {
                    Optional<ConditionJson> originalCondition = processingRule.ruleConditions.stream().filter(condition -> condition.name.equals(conditionJson.name)).findFirst();
                    if (originalCondition.isPresent()) {
                        WorkflowCombiner.combineCondition(originalCondition.get(), overlayActionCondition);
                        continue;
                    }
                    processingRule.ruleConditions.add(overlayActionCondition);
                }
            }
        }
    }

    private static void combineAction(ActionJson action, ActionJson overlayAction) {
        if (overlayAction.mergeMode == MergeMode.REPLACE) {
            action.order = overlayAction.order;
            action.typeId = overlayAction.typeId;
            action.typeName = overlayAction.typeName;
            action.description = overlayAction.description;
            action.settings = overlayAction.settings;
            action.actionConditions = overlayAction.actionConditions;
            return;
        }
        if (!Strings.isNullOrEmpty((String)overlayAction.name)) {
            action.name = overlayAction.name;
        }
        if (overlayAction.order != null) {
            action.order = overlayAction.order;
        }
        if (overlayAction.typeId != null) {
            action.typeId = overlayAction.typeId;
        }
        if (!Strings.isNullOrEmpty((String)overlayAction.typeName)) {
            action.typeName = overlayAction.typeName;
        }
        if (!Strings.isNullOrEmpty((String)overlayAction.description)) {
            action.description = overlayAction.description;
        }
        for (Map.Entry<String, Object> overlaySettingsEntry : overlayAction.settings.entrySet()) {
            action.settings.put(overlaySettingsEntry.getKey(), overlaySettingsEntry.getValue());
        }
        if (overlayAction.actionConditions != null) {
            if (action.actionConditions == null) {
                action.actionConditions = overlayAction.actionConditions;
            } else {
                for (ConditionJson overlayActionCondition : overlayAction.actionConditions) {
                    Optional<ConditionJson> originalCondition = action.actionConditions.stream().filter(condition -> condition.name.equals(conditionJson.name)).findFirst();
                    if (originalCondition.isPresent()) {
                        WorkflowCombiner.combineCondition(originalCondition.get(), overlayActionCondition);
                        continue;
                    }
                    action.actionConditions.add(overlayActionCondition);
                }
            }
        }
    }

    private static void combineCondition(ConditionJson condition, ConditionJson overlayCondition) {
        ConditionAdditionalJson overlayAdditional = overlayCondition.additional;
        if (condition.additional == null) {
            condition.additional = overlayAdditional;
            return;
        }
        if (overlayAdditional != null) {
            if (!Strings.isNullOrEmpty((String)overlayAdditional.notes)) {
                condition.additional.notes = overlayAdditional.notes;
            }
            if (!Strings.isNullOrEmpty((String)overlayAdditional.type)) {
                condition.additional.type = overlayAdditional.type;
            }
            if (overlayAdditional.order != null) {
                condition.additional.order = overlayAdditional.order;
            }
        }
    }
}

