/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization;

import com.github.cafdataprocessing.initialization.jsonobjects.WorkflowJson;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;

public class WorkflowInitializationParams {
    private final String projectId;
    private String workflowBaseDataFileName = null;
    private InputStream workflowBaseDataStream = null;
    private String workflowOverlayFileName = null;
    private InputStream workflowOverlayStream = null;
    private boolean overwriteExisting = true;

    public WorkflowInitializationParams(String workflowBaseDataFileName, String projectId) {
        this.workflowBaseDataFileName = workflowBaseDataFileName;
        this.projectId = projectId;
    }

    public WorkflowInitializationParams(String workflowBaseDataFileName, String workflowOverlayFileName, String projectId) {
        this.workflowBaseDataFileName = workflowBaseDataFileName;
        this.workflowOverlayFileName = workflowOverlayFileName;
        this.projectId = projectId;
    }

    public WorkflowInitializationParams(InputStream workflowBaseDataStream, String projectId) {
        this.workflowBaseDataStream = workflowBaseDataStream;
        this.projectId = projectId;
    }

    public WorkflowInitializationParams(InputStream workflowBaseDataStream, InputStream workflowOverlayStream, String projectId) {
        this.workflowBaseDataStream = workflowBaseDataStream;
        this.workflowOverlayStream = workflowOverlayStream;
        this.projectId = projectId;
    }

    public boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getWorkflowBaseDataFileName() {
        return this.workflowBaseDataFileName;
    }

    public WorkflowJson getWorkflowBaseDataJson() throws IOException {
        if (this.workflowBaseDataStream == null) {
            if (Strings.isNullOrEmpty((String)this.workflowBaseDataFileName)) {
                return null;
            }
            return WorkflowJson.readInputFile(this.workflowBaseDataFileName);
        }
        return WorkflowJson.readInputStream(this.workflowBaseDataStream);
    }

    public InputStream getWorkflowBaseDataStream() {
        return this.workflowBaseDataStream;
    }

    public String getWorkflowOverlayFileName() {
        return this.workflowOverlayFileName;
    }

    public WorkflowJson getWorkflowOverlayJson() throws IOException {
        if (this.workflowOverlayStream == null) {
            if (Strings.isNullOrEmpty((String)this.workflowOverlayFileName)) {
                return null;
            }
            return WorkflowJson.readInputFile(this.workflowOverlayFileName);
        }
        return WorkflowJson.readInputStream(this.workflowOverlayStream);
    }

    public InputStream getWorkflowOverlayStream() {
        return this.workflowOverlayStream;
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public void setWorkflowOverlayFileName(String workflowOverlayFileName) {
        this.workflowOverlayFileName = workflowOverlayFileName;
    }

    public void setWorkflowOverlayStream(InputStream workflowOverlayStream) {
        this.workflowOverlayStream = workflowOverlayStream;
    }
}

