/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization;

import com.github.cafdataprocessing.initialization.ActionTypeNameResolver;
import com.github.cafdataprocessing.initialization.ProcessingApisProvider;
import com.github.cafdataprocessing.initialization.WorkflowCombiner;
import com.github.cafdataprocessing.initialization.WorkflowInitializationParams;
import com.github.cafdataprocessing.initialization.WorkflowRemover;
import com.github.cafdataprocessing.initialization.boilerplate.BoilerplateNameResolver;
import com.github.cafdataprocessing.initialization.jsonobjects.ActionJson;
import com.github.cafdataprocessing.initialization.jsonobjects.ProcessingRuleJson;
import com.github.cafdataprocessing.initialization.jsonobjects.WorkflowJson;
import com.github.cafdataprocessing.initialization.jsonobjects.conditions.ConditionJson;
import com.github.cafdataprocessing.processing.service.client.ApiException;
import com.github.cafdataprocessing.processing.service.client.api.ActionConditionsApi;
import com.github.cafdataprocessing.processing.service.client.api.ActionTypesApi;
import com.github.cafdataprocessing.processing.service.client.api.ActionsApi;
import com.github.cafdataprocessing.processing.service.client.api.ProcessingRulesApi;
import com.github.cafdataprocessing.processing.service.client.api.ProcessingRulesConditionsApi;
import com.github.cafdataprocessing.processing.service.client.api.WorkflowsApi;
import com.github.cafdataprocessing.processing.service.client.model.Action;
import com.github.cafdataprocessing.processing.service.client.model.ExistingAction;
import com.github.cafdataprocessing.processing.service.client.model.ExistingProcessingRule;
import com.github.cafdataprocessing.processing.service.client.model.ExistingWorkflow;
import com.google.common.base.Strings;
import com.hpe.caf.boilerplate.webcaller.ApiClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowInitializer.class);
    private final WorkflowsApi workflowsApi;
    private final ProcessingRulesApi processingRulesApi;
    private final ActionsApi actionsApi;
    private final ActionTypesApi actionTypesApi;
    private final ActionConditionsApi actionConditionsApi;
    private final ProcessingRulesConditionsApi rulesConditionsApi;
    private final ProcessingApisProvider apisProvider;
    private ActionTypeNameResolver actionTypeNameResolver;
    private final BoilerplateNameResolver boilerplateNameResolver;

    public WorkflowInitializer(String processingApiUrl, BoilerplateNameResolver boilerplateNameResolver, ActionTypeNameResolver actionTypeNameResolver) {
        com.github.cafdataprocessing.processing.service.client.ApiClient apiClient = new com.github.cafdataprocessing.processing.service.client.ApiClient();
        apiClient.setBasePath(processingApiUrl);
        this.apisProvider = new ProcessingApisProvider(apiClient);
        this.workflowsApi = this.apisProvider.getWorkflowsApi();
        this.processingRulesApi = this.apisProvider.getProcessingRulesApi();
        this.actionsApi = this.apisProvider.getActionsApi();
        this.actionTypesApi = this.apisProvider.getActionTypesApi();
        this.actionConditionsApi = this.apisProvider.getActionConditionsApi();
        this.rulesConditionsApi = this.apisProvider.getRulesConditionsApi();
        this.actionTypeNameResolver = actionTypeNameResolver;
        this.boilerplateNameResolver = boilerplateNameResolver;
    }

    public static WorkflowInitializer createWorkflowInitializer(String processingApiUrl, String boilerplateApiUrl) {
        ApiClient boilerplateClient = new ApiClient();
        boilerplateClient.setBasePath(boilerplateApiUrl);
        BoilerplateNameResolver boilerplateNameResolver = new BoilerplateNameResolver(boilerplateClient);
        return new WorkflowInitializer(processingApiUrl, boilerplateNameResolver, new ActionTypeNameResolver());
    }

    public static WorkflowInitializer createWorkflowOnlyInitializer(String processingApiUrl) {
        return new WorkflowInitializer(processingApiUrl, new BoilerplateNameResolver(null), new ActionTypeNameResolver());
    }

    private void retrieveActionTypeInformation(String projectId) throws ApiException {
        LOGGER.debug("Retrieving action types information for action creation.");
        this.actionTypeNameResolver.populateActionTypesFromApi(this.actionTypesApi, projectId);
        LOGGER.debug("Retrieved action types information for action creation.");
    }

    public long initializeWorkflowBaseData(String inputFileName, String projectId) throws IOException, ApiException {
        return this.initializeWorkflowBaseData(inputFileName, null, projectId);
    }

    public long initializeWorkflowBaseData(String inputFileName, String overlayFile, String projectId) throws IOException, ApiException {
        WorkflowJson workflowToCreate = WorkflowJson.readInputFile(inputFileName);
        WorkflowJson overlayWorkflow = Strings.isNullOrEmpty((String)overlayFile) ? null : WorkflowJson.readInputFile(overlayFile);
        return this.createWorkflow(workflowToCreate, overlayWorkflow, projectId);
    }

    public long initializeWorkflowBaseData(InputStream workflowBaseDataStream, InputStream workflowOverlayStream, String projectId) throws IOException, ApiException {
        WorkflowJson workflowToCreate = WorkflowJson.readInputStream(workflowBaseDataStream);
        WorkflowJson overlayWorkflow = workflowOverlayStream == null ? null : WorkflowJson.readInputStream(workflowOverlayStream);
        return this.createWorkflow(workflowToCreate, overlayWorkflow, projectId);
    }

    public long initializeWorkflowBaseData(WorkflowInitializationParams initializationParams) throws IOException, ApiException {
        return this.createWorkflow(initializationParams.getWorkflowBaseDataJson(), initializationParams.getWorkflowOverlayJson(), initializationParams.getProjectId(), initializationParams.getOverwriteExisting());
    }

    public long createWorkflow(WorkflowJson workflow, WorkflowJson workflowOverlay, String projectId) throws ApiException {
        return this.createWorkflow(workflow, workflowOverlay, projectId, true);
    }

    public long createWorkflow(WorkflowJson workflow, WorkflowJson workflowOverlay, String projectId, boolean overwriteExisting) throws ApiException {
        this.retrieveActionTypeInformation(projectId);
        WorkflowCombiner.combineWorkflows(workflow, workflowOverlay);
        if (overwriteExisting) {
            WorkflowRemover.removeMatchingWorkflows(this.apisProvider, projectId, workflow.name);
        }
        ExistingWorkflow createdWorkflow = this.workflowsApi.createWorkflow(projectId, workflow.toApiBaseWorkflow());
        long createdWorkflowId = createdWorkflow.getId();
        for (ProcessingRuleJson ruleToCreate : workflow.processingRules) {
            this.createProcessingRule(ruleToCreate, createdWorkflowId, projectId);
        }
        return createdWorkflowId;
    }

    private void createProcessingRule(ProcessingRuleJson processingRule, long workflowId, String projectId) throws ApiException {
        ExistingProcessingRule createdRule = this.processingRulesApi.createRule(projectId, Long.valueOf(workflowId), processingRule.toApiBaseProcessingRule());
        long createdRuleId = createdRule.getId();
        for (ActionJson actionToCreate : processingRule.actions) {
            this.createAction(actionToCreate, workflowId, createdRuleId, projectId);
        }
        for (ConditionJson conditionToCreate : processingRule.ruleConditions) {
            this.createRuleCondition(conditionToCreate, workflowId, createdRuleId, projectId);
        }
    }

    private void createAction(ActionJson actionJson, long workflowId, long ruleId, String projectId) throws ApiException {
        ExistingAction createdAction;
        Action actionToCreate = actionJson.toApiAction(this.actionTypeNameResolver.getActionTypesNamesToIds());
        this.replaceBoilerplateNamesIfRequired(actionToCreate);
        try {
            createdAction = this.actionsApi.createAction(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), actionToCreate);
        }
        catch (ApiException e) {
            throw new RuntimeException("Failure trying to create action with name: " + actionToCreate.getName(), e);
        }
        long createdActionId = createdAction.getId();
        for (ConditionJson conditionToCreate : actionJson.actionConditions) {
            this.createActionCondition(conditionToCreate, workflowId, ruleId, createdActionId, projectId);
        }
    }

    private void createActionCondition(ConditionJson conditionJson, long workflowId, long ruleId, long actionId, String projectId) throws ApiException {
        this.actionConditionsApi.createActionCondition(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), Long.valueOf(actionId), conditionJson.toApiCondition());
    }

    private void createRuleCondition(ConditionJson conditionJson, long workflowId, long ruleId, String projectId) throws ApiException {
        this.rulesConditionsApi.createRuleCondition(projectId, Long.valueOf(workflowId), Long.valueOf(ruleId), conditionJson.toApiCondition());
    }

    private void replaceBoilerplateNamesIfRequired(Action action) {
        String tagIdKey;
        Object tagIdObj;
        String expressionIdsKey;
        Long actionTypeId = action.getTypeId();
        String actionTypeInternalName = this.actionTypeNameResolver.getActionTypesIdsToNames().get(actionTypeId);
        if (!actionTypeInternalName.equals("BoilerplatePolicyType")) {
            return;
        }
        LinkedHashMap actionSettings = (LinkedHashMap)action.getSettings();
        Object expressionIdsObj = actionSettings.get(expressionIdsKey = "expressionIds");
        if (expressionIdsObj != null) {
            List<Object> updatedExpressionIds = this.boilerplateNameResolver.resolveExpressionIds((ArrayList)expressionIdsObj);
            actionSettings.put(expressionIdsKey, updatedExpressionIds);
        }
        if ((tagIdObj = actionSettings.get(tagIdKey = "tagId")) != null) {
            Object updatedTagId = this.boilerplateNameResolver.resolveTagId(tagIdObj);
            actionSettings.put(tagIdKey, updatedTagId);
        }
    }
}

