/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization;

import com.github.cafdataprocessing.initialization.ProcessingApisProvider;
import com.github.cafdataprocessing.processing.service.client.ApiException;
import com.github.cafdataprocessing.processing.service.client.api.ProcessingRulesApi;
import com.github.cafdataprocessing.processing.service.client.api.WorkflowsApi;
import com.github.cafdataprocessing.processing.service.client.model.ExistingProcessingRule;
import com.github.cafdataprocessing.processing.service.client.model.ExistingWorkflow;
import com.github.cafdataprocessing.processing.service.client.model.ExistingWorkflows;
import com.github.cafdataprocessing.processing.service.client.model.ProcessingRules;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowRemover {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowRemover.class);

    public static void removeMatchingWorkflows(ProcessingApisProvider apisProvider, String projectId, String workflowNameToRemove) throws ApiException {
        LOGGER.info("Checking for existing processing workflows that should be removed using name: " + workflowNameToRemove);
        if (workflowNameToRemove == null) {
            LOGGER.warn("Workflow name to use in checking existing processing workflows to remove cannot be null. Workflows will not be checked.");
            return;
        }
        WorkflowsApi workflowsApi = apisProvider.getWorkflowsApi();
        List<ExistingWorkflow> existingWorkflows = WorkflowRemover.retrieveExistingWorkflows(workflowsApi, projectId);
        if (existingWorkflows.isEmpty()) {
            LOGGER.info("There are no existing processing workflows to remove.");
            return;
        }
        ProcessingRulesApi processingRulesApi = apisProvider.getProcessingRulesApi();
        for (ExistingWorkflow existingWorkflow : existingWorkflows) {
            Long existingWorkflowId = existingWorkflow.getId();
            if (existingWorkflow.getName().equals(workflowNameToRemove)) {
                LOGGER.debug("Existing processing workflow matches name: " + workflowNameToRemove + ", has ID: " + existingWorkflowId + ". Workflow will be removed.");
                ArrayList<ExistingProcessingRule> processingRulesToRemove = new ArrayList<ExistingProcessingRule>();
                int pageNum = 1;
                int pageSize = 100;
                while (true) {
                    ProcessingRules retrieveProcessingRulesResult = processingRulesApi.getRules(projectId, existingWorkflowId, Integer.valueOf(pageNum), Integer.valueOf(100));
                    processingRulesToRemove.addAll(retrieveProcessingRulesResult.getRules());
                    if (retrieveProcessingRulesResult.getTotalHits() <= (long)(pageNum * 100)) break;
                    ++pageNum;
                }
                WorkflowRemover.removeProcessingRules(processingRulesApi, projectId, existingWorkflowId, processingRulesToRemove);
                LOGGER.debug("Removed all processing rules for workflow: " + existingWorkflowId);
                workflowsApi.deleteWorkflow(projectId, existingWorkflowId);
                LOGGER.debug("Removed processing workflow: " + existingWorkflowId);
            }
            LOGGER.info("Removed any existing processing workflows with name: " + workflowNameToRemove);
        }
    }

    private static void removeProcessingRules(ProcessingRulesApi processingRulesApi, String projectId, Long workflowId, List<ExistingProcessingRule> processingRulesToRemove) throws ApiException {
        for (ExistingProcessingRule processingRuleToRemove : processingRulesToRemove) {
            Long ruleToRemoveId = processingRuleToRemove.getId();
            LOGGER.debug("Removing processing rule with ID: " + ruleToRemoveId + " under workflow with ID: " + workflowId);
            processingRulesApi.deleteRule(projectId, workflowId, ruleToRemoveId);
            LOGGER.debug("Removed processing rule with ID: " + ruleToRemoveId);
        }
    }

    private static List<ExistingWorkflow> retrieveExistingWorkflows(WorkflowsApi workflowsApi, String projectId) throws ApiException {
        ArrayList<ExistingWorkflow> existingWorkflows = new ArrayList<ExistingWorkflow>();
        int pageNum = 1;
        int pageSize = 100;
        LOGGER.debug("Retrieving existing processing workflows to check their names");
        while (true) {
            ExistingWorkflows retrieveWorkflowResult = workflowsApi.getWorkflows(projectId, Integer.valueOf(pageNum), Integer.valueOf(100));
            existingWorkflows.addAll(retrieveWorkflowResult.getWorkflows());
            if (retrieveWorkflowResult.getTotalHits() <= pageNum * 100) break;
            ++pageNum;
        }
        LOGGER.debug("Retrieved all existing processing workflows.");
        return existingWorkflows;
    }
}

