/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization.boilerplate;

import com.github.cafdataprocessing.initialization.boilerplate.CreationResultJson;
import com.github.cafdataprocessing.initialization.boilerplate.CreationResultOutputJson;
import com.google.common.base.Strings;
import com.hpe.caf.boilerplate.webcaller.ApiClient;
import com.hpe.caf.boilerplate.webcaller.ApiException;
import com.hpe.caf.boilerplate.webcaller.api.BoilerplateApi;
import com.hpe.caf.boilerplate.webcaller.model.BoilerplateExpression;
import com.hpe.caf.boilerplate.webcaller.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoilerplateNameResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoilerplateNameResolver.class);
    private Map<String, Long> expressionIds = new LinkedHashMap<String, Long>();
    private Map<String, Long> tagIds = new LinkedHashMap<String, Long>();
    private final BoilerplateApi boilerplateApi;

    public BoilerplateNameResolver(ApiClient apiClient) {
        this.boilerplateApi = apiClient != null ? new BoilerplateApi(apiClient) : null;
    }

    public void populateFromCreationResult(CreationResultJson boilerplateCreationResult) {
        if (boilerplateCreationResult != null) {
            Collection<CreationResultOutputJson> creationResultTags;
            Collection<CreationResultOutputJson> creationResultExpressions = boilerplateCreationResult.expressions;
            if (creationResultExpressions != null) {
                creationResultExpressions.stream().forEach(ex -> this.expressionIds.put(ex.name, ex.id));
            }
            if ((creationResultTags = boilerplateCreationResult.tags) != null) {
                creationResultTags.stream().forEach(tag -> this.tagIds.put(tag.name, tag.id));
            }
        }
    }

    public void populateExpressionsFromApiCall(String projectId) throws ApiException {
        int retrievedHitsSize;
        if (this.boilerplateApi == null) {
            LOGGER.error("Boilerplate API is not configured for usage, unable to retrieve expressions.");
            return;
        }
        int pageIndex = 1;
        int pageSize = 100;
        if (!Strings.isNullOrEmpty((String)projectId)) {
            this.boilerplateApi.getApiClient().setApiKey(projectId);
        }
        do {
            List retrievedExpressions = this.boilerplateApi.getExpressions(Integer.valueOf(pageIndex), Integer.valueOf(pageSize));
            pageIndex += pageSize;
            retrievedHitsSize = retrievedExpressions.size();
            for (BoilerplateExpression retrievedExpression : retrievedExpressions) {
                if (this.expressionIds.containsKey(retrievedExpression.getName())) continue;
                this.expressionIds.put(retrievedExpression.getName(), retrievedExpression.getId());
            }
        } while (retrievedHitsSize >= pageSize);
    }

    public void populateExpressionsFromApiCall() throws ApiException {
        this.populateExpressionsFromApiCall(null);
    }

    public void populateTagsFromApiCall() throws ApiException {
        int retrievedHitsSize;
        if (this.boilerplateApi == null) {
            LOGGER.error("Boilerplate API is not configured for usage, unable to retrieve tags.");
            return;
        }
        int pageIndex = 1;
        int pageSize = 100;
        do {
            List retrievedTags = this.boilerplateApi.getTags(Integer.valueOf(pageIndex), Integer.valueOf(pageSize));
            retrievedHitsSize = retrievedTags.size();
            pageIndex += pageSize;
            for (Tag retrievedTag : retrievedTags) {
                if (this.tagIds.containsKey(retrievedTag.getName())) continue;
                this.tagIds.put(retrievedTag.getName(), retrievedTag.getId());
            }
        } while (retrievedHitsSize >= pageSize);
    }

    public Long resolveFromTagName(String tagName) {
        Long matchedTagId = this.tagIds.get(tagName);
        if (matchedTagId != null) {
            return matchedTagId;
        }
        try {
            this.populateTagsFromApiCall();
        }
        catch (ApiException e) {
            LOGGER.error("Failure trying to retrieve tag information from boilerplate API.", (Throwable)e);
        }
        return this.tagIds.get(tagName);
    }

    public Long resolveFromExpressionName(String expressionName) {
        Long matchedExpId = this.expressionIds.get(expressionName);
        if (matchedExpId != null) {
            return matchedExpId;
        }
        try {
            this.populateExpressionsFromApiCall();
        }
        catch (ApiException e) {
            LOGGER.error("Failure trying to retrieve expression information from boilerplate API.", (Throwable)e);
        }
        return this.expressionIds.get(expressionName);
    }

    public List<Object> resolveExpressionIds(ArrayList expressionIdsObj) {
        if (expressionIdsObj == null) {
            return null;
        }
        ArrayList<Object> newExpressionIds = new ArrayList<Object>();
        ArrayList expressionIds = expressionIdsObj;
        for (Object expressionId : expressionIds) {
            if (expressionId instanceof Integer || expressionId instanceof Long) {
                newExpressionIds.add(expressionId);
                continue;
            }
            Long resolvedExpId = this.resolveFromExpressionName((String)expressionId);
            if (resolvedExpId == null) {
                throw new RuntimeException("Failure trying to resolve expression ID using value: " + expressionId);
            }
            newExpressionIds.add(resolvedExpId);
        }
        return newExpressionIds;
    }

    public Object resolveTagId(Object tagId) {
        if (tagId == null) {
            return null;
        }
        if (tagId instanceof Integer | tagId instanceof Long) {
            return tagId;
        }
        Long resolvedTagId = this.resolveFromTagName((String)tagId);
        if (resolvedTagId == null) {
            throw new RuntimeException("Failure trying to resolve tag ID using value: " + tagId);
        }
        return resolvedTagId;
    }
}

