/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.initialization.jsonobjects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.cafdataprocessing.initialization.jsonobjects.ProcessingRuleJson;
import com.github.cafdataprocessing.processing.service.client.model.BaseWorkflow;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkflowJson {
    private static final ObjectMapper mapper = new ObjectMapper();
    public final String name;
    public final String description;
    public final String notes;
    public final List<ProcessingRuleJson> processingRules;

    public WorkflowJson(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="description") String description, @JsonProperty(value="notes") String notes, @JsonProperty(value="processingRules") List<ProcessingRuleJson> processingRules) {
        this.name = name;
        this.description = description;
        this.notes = notes;
        this.processingRules = processingRules == null ? new ArrayList() : processingRules;
    }

    public BaseWorkflow toApiBaseWorkflow() {
        BaseWorkflow workflow = new BaseWorkflow();
        workflow.setName(this.name);
        workflow.setDescription(this.description);
        workflow.setNotes(this.notes);
        return workflow;
    }

    public static WorkflowJson readInputFile(String inputFilepath) throws IOException, NullPointerException {
        File baseDataFile = new File(inputFilepath);
        try {
            return (WorkflowJson)mapper.readValue(baseDataFile, WorkflowJson.class);
        }
        catch (IOException e) {
            throw new IOException("Failure trying to deserialize the workflow base data input file. Please check the format of the file contents.", e);
        }
    }

    public static WorkflowJson readInputStream(InputStream inputStream) throws IOException, NullPointerException {
        Objects.requireNonNull(inputStream);
        try {
            return (WorkflowJson)mapper.readValue(inputStream, WorkflowJson.class);
        }
        catch (IOException e) {
            throw new IOException("Failure trying to deserialize the workflow base data input stream. Please check the format of the input stream.", e);
        }
    }
}

