/*
 * Copyright 2021 catdou
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.catdou.validate.xml;

import org.catdou.validate.exception.ParseException;
import org.w3c.dom.Document;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;

/**
 * @author James
 */
public class XmlParser {

    protected Document document;

    protected XPath xpath;

    public XmlParser(XmlDocument xmlDocument) {
        document = xmlDocument.getDocument();
        xpath = XmlDocument.getXpath();
    }

    public Object evaluate(String expression, Object item, QName returnType) {
        try {
            return xpath.evaluate(expression, item, returnType);
        } catch (XPathExpressionException e) {
            throw new ParseException("xpath evaluate error ", e);
        }
    }


}
