/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary;

import cfml.dictionary.SyntaxDictionary;
import cfml.dictionary.preferences.DictionaryPreferences;
import cfml.dictionary.syntax.HTMLSyntaxDictionary;
import cfml.dictionary.syntax.JSSyntaxDictionary;
import cfml.dictionary.syntax.SQLSyntaxDictionary;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DictionaryManager {
    public static String DICTIONARY_DIR = "";
    public static String CF_DICTIONARY;
    public static final String CFDIC_KEY = "CF_DICTIONARY";
    public static final String JSDIC_KEY = "JS_DICTIONARY";
    public static final String SQLDIC_KEY = "SQL_DICTIONARY";
    public static final String HTDIC_KEY = "HT_DICTIONARY";
    private static Map dictionaries;
    private static Map dictionariesCache;
    private static Map dictionaryVersionCache;
    private static org.w3c.dom.Document dictionaryConfig;
    private static DictionaryPreferences fPrefs;
    private static String fBuiltInDictionaryPath;

    private DictionaryManager(DictionaryPreferences prefs) {
        fPrefs = prefs;
        DictionaryManager.init();
    }

    private static void init() {
        try {
            fBuiltInDictionaryPath = "jar:" + DictionaryManager.class.getClassLoader().getResource("org.cfeclipse.cfml/dictionary/dictionaryconfig.xml").getFile().replace("dictionaryconfig.xml", "");
        }
        catch (Exception e) {
            fBuiltInDictionaryPath = "jar:file:" + DictionaryManager.class.getResource("/dictionaries.zip").getFile() + "!/org.cfeclipse.cfml/dictionary/";
        }
        DICTIONARY_DIR = fPrefs.getDictionaryDir();
        CF_DICTIONARY = fPrefs.getCFDictionary();
    }

    private static void loadDictionaryConfig() {
        try {
            if (fPrefs == null) {
                fPrefs = new DictionaryPreferences();
                DictionaryManager.init();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setCoalescing(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            dictionaryConfig = fPrefs.getDictionaryDir().length() != 0 ? builder.parse(new File(fPrefs.getDictionaryDir() + "/dictionaryconfig.xml")) : builder.parse(DictionaryManager.class.getResourceAsStream("/org.cfeclipse.cfml/dictionary/dictionaryconfig.xml"));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void initDictionaries() {
        DictionaryManager.loadDictionaryConfig();
        String cfdictversion = DictionaryManager.getInitialDictVersion();
        if (dictionaryConfig == null) {
            throw new IllegalArgumentException("Problem loading dictionaryconfig.xml");
        }
        if (cfdictversion.trim().length() == 0) {
            cfdictversion = DictionaryManager.getFirstVersion(CFDIC_KEY);
        }
        String htdictversion = DictionaryManager.getFirstVersion(HTDIC_KEY);
        String jsdictversion = DictionaryManager.getFirstVersion(JSDIC_KEY);
        DictionaryManager.loadDictionaryByVersion(cfdictversion);
        DictionaryManager.loadDictionaryByVersion(htdictversion);
        DictionaryManager.loadDictionaryByVersion(jsdictversion);
        DictionaryManager.loadDictionaryFromCache(cfdictversion, CFDIC_KEY);
        DictionaryManager.loadDictionaryFromCache(cfdictversion, SQLDIC_KEY);
        DictionaryManager.loadDictionaryFromCache(htdictversion, HTDIC_KEY);
        DictionaryManager.loadDictionaryFromCache(jsdictversion, JSDIC_KEY);
    }

    public static void initDictionaries(DictionaryPreferences prefs) {
        fPrefs = prefs;
        DictionaryManager.init();
        DictionaryManager.initDictionaries();
    }

    private static String getInitialDictVersion() {
        return CF_DICTIONARY;
    }

    public static String getFirstVersion(String forDictionary) {
        return dictionaryConfig.getElementById(forDictionary).getFirstChild().getAttributes().getNamedItem("key").getNodeValue();
    }

    public static String[][] getConfiguredDictionaries() {
        NodeList cfmltypes = dictionaryConfig.getElementById(CFDIC_KEY).getChildNodes();
        byte typeslen = (byte)cfmltypes.getLength();
        String[][] options = new String[typeslen][2];
        for (byte z = 0; z < typeslen; z = (byte)(z + 1)) {
            String label;
            String key = cfmltypes.item(z).getAttributes().getNamedItem("key").getNodeValue();
            options[z][0] = label = cfmltypes.item(z).getAttributes().getNamedItem("label").getNodeValue();
            options[z][1] = key;
        }
        return options;
    }

    public static void loadDictionaryByVersion(String versionkey) {
        SyntaxDictionary dic = DictionaryManager.getDictionaryByVersion(versionkey);
        if (dic == null) {
            throw new IllegalArgumentException("Problem loading version node " + versionkey + " from dictionaryconfig.xml");
        }
        DictionaryManager.addDictionaryToCache(versionkey, dic);
    }

    public static SyntaxDictionary getDictionaryByVersionAlt(String versionkey) {
        if (dictionaryVersionCache.containsKey(versionkey)) {
            return (SyntaxDictionary)dictionaryVersionCache.get(versionkey);
        }
        SAXBuilder builder = new SAXBuilder();
        SQLSyntaxDictionary dic = new SQLSyntaxDictionary();
        URL dictionaryConfigURL = null;
        try {
            dictionaryConfigURL = new URL(DICTIONARY_DIR);
            URL configurl = new URL(dictionaryConfigURL, "dictionaryconfig.xml");
            Document document = builder.build(configurl);
            XPath x = XPath.newInstance((String)("//dictionary[@id='CF_DICTIONARY']/version[@key='" + versionkey + "']/grammar[1]"));
            Element grammerElement = (Element)x.selectSingleNode((Object)document);
            dic = new SQLSyntaxDictionary();
            dic.loadDictionary(DictionaryManager.getDictionaryLocation(grammerElement.getAttributeValue("location")));
            dictionaryVersionCache.put(versionkey, dic);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (SyntaxDictionary)dictionaryVersionCache.get(versionkey);
    }

    public static SyntaxDictionary getDictionaryByVersion(String versionkey) {
        if (dictionaryConfig == null) {
            throw new IllegalArgumentException("Problem loading dictionaryconfig.xml");
        }
        org.w3c.dom.Element versionNode = dictionaryConfig.getElementById(versionkey);
        if (versionNode == null) {
            return null;
        }
        String dicttype = versionNode.getParentNode().getAttributes().getNamedItem("id").getNodeValue();
        SyntaxDictionary dic = null;
        if (dicttype.equals(CFDIC_KEY)) {
            dic = new SQLSyntaxDictionary();
            String sqlwords = dictionaryConfig.getElementById(SQLDIC_KEY).getFirstChild().getFirstChild().getAttributes().getNamedItem("location").getNodeValue();
            try {
                ((SQLSyntaxDictionary)dic).loadKeywords(new URL(DictionaryManager.getDictionaryLocation(sqlwords)));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Problem loading version node " + sqlwords + " from dictionaryconfig.xml");
            }
        } else if (dicttype.equals(JSDIC_KEY)) {
            dic = new JSSyntaxDictionary();
        } else if (dicttype.equals(HTDIC_KEY)) {
            dic = new HTMLSyntaxDictionary();
        }
        NodeList grammars = versionNode.getChildNodes();
        byte nlen = (byte)grammars.getLength();
        Node n = null;
        for (byte z = 0; z < nlen; z = (byte)(z + 1)) {
            n = grammars.item(z);
            String filename = n.getAttributes().getNamedItem("location").getNodeValue().trim();
            dic.loadDictionary(DictionaryManager.getDictionaryLocation(filename));
        }
        return dic;
    }

    private static String getDictionaryLocation(String path) {
        if (fPrefs.getDictionaryDir().length() == 0) {
            path = DictionaryManager.class.getResource("/org.cfeclipse.cfml/dictionary/" + path).toString();
            if (path == null) {
                path = fBuiltInDictionaryPath + path;
            }
        } else if (path.startsWith("http")) {
            File dictFile = new File(fPrefs.getDictionaryDir() + path);
            if (!dictFile.exists()) {
                try {
                    URL url = new URL(path);
                    InputStream inputStream = url.openStream();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            File dictDir = new File(fPrefs.getDictionaryDir());
            path = "file:" + dictDir.getAbsolutePath() + "/" + path;
        }
        return path;
    }

    public static synchronized void loadDictionaryFromCache(String cachekey, String livekey) {
        DictionaryManager.loadDictionaryFromCache(cachekey, livekey, false);
    }

    private static synchronized void loadDictionaryFromCache(String cachekey, String livekey, boolean retry) {
        if (dictionariesCache.containsKey(cachekey) && dictionaries.containsKey(livekey)) {
            Object tdic = dictionariesCache.get(cachekey);
            dictionaries.put(livekey, tdic);
        } else if (dictionariesCache.containsKey(cachekey)) {
            dictionaries.put(livekey, dictionariesCache.get(cachekey));
        } else if (!dictionariesCache.containsKey(cachekey) && cachekey != null && cachekey.length() > 0) {
            if (retry) {
                System.out.println("Error! Dictionary " + cachekey + " could not be loaded.\n This may cause CFEclipse to work unpredictably or, in some cases, not at all.\n\nTry closing Eclipse and starting it from the command line with -clean as a command line argument.");
                throw new IllegalArgumentException("Problem loading version node " + cachekey + " from dictionaryconfig.xml");
            }
            DictionaryManager.loadDictionaryByVersion(cachekey);
            DictionaryManager.loadDictionaryFromCache(cachekey, livekey, true);
        } else {
            if (cachekey != null || cachekey.length() > 0) {
                return;
            }
            throw new IllegalArgumentException("Cache key: " + cachekey + " is not in the cache" + dictionariesCache.keySet().toString());
        }
    }

    public static void addDictionaryToCache(String key, SyntaxDictionary sd) {
        dictionariesCache.put(key, sd);
    }

    public static void addDictionary(String key, SyntaxDictionary sd) {
        dictionaries.put(key, sd);
    }

    public static SyntaxDictionary getDictionary(String key) {
        SyntaxDictionary dict = (SyntaxDictionary)dictionaries.get(key);
        return dict;
    }

    public static Map getDictionaries() {
        return dictionaries;
    }

    public static Map getDictionariesCache() {
        return dictionariesCache;
    }

    public static void setDictionariesCache(Map dictionariesCache) {
        DictionaryManager.dictionariesCache = dictionariesCache;
    }

    static {
        dictionaries = new HashMap();
        dictionariesCache = new HashMap();
        dictionaryVersionCache = new HashMap();
        dictionaryConfig = null;
    }
}

