/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary;

import cfml.dictionary.Trigger;
import cfml.dictionary.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Parameter
implements Comparable {
    public static final int PARAM_NOTTRIGGERED = 0;
    public static final int PARAM_TRIGGERED = 1;
    public static final int PARAM_REQUIRED = 2;
    public static final int PARAM_NOTREQUIRED = 3;
    private Trigger activeTrigger = null;
    ArrayList triggers = new ArrayList();
    protected String name = "";
    protected String type = "void";
    protected String help = "";
    protected String defaultValue = "";
    protected Set values;
    protected boolean required = false;
    protected String category = "General";

    public void addTrigger(Trigger newTriggerSet) {
        this.triggers.add(newTriggerSet);
    }

    public ArrayList getTriggers() {
        return this.triggers;
    }

    public int isTriggered(HashMap availParams) {
        if (this.triggers.size() == 0 && this.required) {
            this.activeTrigger = null;
            return 3;
        }
        if (this.triggers.size() == 0) {
            this.activeTrigger = null;
            return 1;
        }
        for (Trigger currTrigger : this.triggers) {
            int trigVal = currTrigger.WillTrigger(availParams);
            if ((trigVal & 1) != 1) continue;
            this.activeTrigger = currTrigger;
            return trigVal;
        }
        this.activeTrigger = null;
        return 0;
    }

    public int isRequired(HashMap availParams) {
        if (this.triggers.size() == 0 && this.required) {
            this.activeTrigger = null;
            return 3;
        }
        for (Trigger currTrigger : this.triggers) {
            int trigVal = currTrigger.WillTrigger(availParams);
            if ((trigVal & 1) != 1 || !currTrigger.isRequired) continue;
            this.activeTrigger = currTrigger;
            return 3;
        }
        this.activeTrigger = null;
        return 0;
    }

    public Parameter(String name) {
        this.name = name.trim();
    }

    public Parameter(String name, String type) {
        this.setNameAndType(name, type);
    }

    public Parameter(String name, String type, boolean required) {
        this.setNameAndType(name, type);
        this.required = required;
    }

    public Parameter(String name, String type, boolean required, String defaultValue) {
        this.setNameAndType(name, type);
        this.required = required;
        this.defaultValue = defaultValue;
    }

    public Parameter(String name, String type, boolean required, String defaultValue, String category) {
        this.setNameAndType(name, type);
        this.required = required;
        this.defaultValue = defaultValue;
        this.category = category;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Trigger activeTrigger() {
        return this.activeTrigger;
    }

    public void setNameAndType(String name, String type) {
        this.name = name.trim();
        this.type = type.toLowerCase();
    }

    public void addValue(Value value) {
        if (this.values == null) {
            this.values = new HashSet();
        }
        this.values.add(value);
    }

    public Set getValues() {
        if (this.values == null) {
            return new HashSet();
        }
        return this.values;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.required) {
            sb.append(String.valueOf(this.name) + " - " + this.type);
        } else {
            sb.append("[" + this.name + " - " + this.type);
            if (this.defaultValue != null) {
                sb.append(" \"" + this.defaultValue + "\"");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof Parameter && ((Parameter)obj).getName().equals(this.name) && ((Parameter)obj).getType().equals(this.type);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Null!");
        }
        if (o instanceof Parameter) {
            return this.name.compareTo(((Parameter)o).getName());
        }
        return 0;
    }

    public String getCategory() {
        return this.category;
    }
}

