/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary;

import cfml.dictionary.Component;
import cfml.dictionary.DictionaryContentHandler;
import cfml.dictionary.DictionaryManager;
import cfml.dictionary.Function;
import cfml.dictionary.Parameter;
import cfml.dictionary.Procedure;
import cfml.dictionary.ScopeVar;
import cfml.dictionary.Tag;
import cfml.dictionary.Value;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class SyntaxDictionary {
    protected Map<String, Object> syntaxelements = new HashMap<String, Object>();
    protected Map<String, Object> functions = new HashMap<String, Object>();
    protected Map<String, Object> scopeVars = new HashMap<String, Object>();
    protected Map<String, Object> scopes = new HashMap<String, Object>();
    protected String dictionaryURL = null;

    public void loadDictionary(String url) {
        this.setURL(url);
        try {
            this.loadDictionary();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setURL(String url) {
        this.dictionaryURL = url;
    }

    public Set<String> getAllElements() {
        return this.syntaxelements.keySet();
    }

    public Set<Tag> getAllTags() {
        HashSet<Tag> total = new HashSet<Tag>();
        Set<String> keys = this.getAllElements();
        if (keys == null) {
            return total;
        }
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            total.add((Tag)this.syntaxelements.get(it.next()));
        }
        return total;
    }

    public Set<Function> getAllFunctions() {
        HashSet<Function> total = new HashSet<Function>();
        Set<String> keys = this.getFunctions();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            total.add((Function)this.functions.get(it.next()));
        }
        return total;
    }

    public Set<Object> getAllScopes() {
        HashSet<Object> total = new HashSet<Object>();
        Set<String> keys = this.scopes.keySet();
        Iterator<String> it = keys.iterator();
        String name = null;
        while (it.hasNext()) {
            name = it.next().toString();
            total.add(this.scopes.get(name));
        }
        return total;
    }

    public Set<Object> getAllScopeVars() {
        HashSet<Object> total = new HashSet<Object>();
        Set<String> keys = this.scopeVars.keySet();
        Iterator<String> it = keys.iterator();
        String name = null;
        while (it.hasNext()) {
            name = it.next();
            total.add(this.scopeVars.get(name));
        }
        return total;
    }

    public Set<Object> getFilteredElements(String start) {
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !start.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionary::getFilteredElements() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + start + "'");
        }
        HashSet<Object> elements = new HashSet<Object>();
        Set<String> keys = this.getAllElements();
        if (keys == null) {
            return elements;
        }
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            elements.add(this.syntaxelements.get(it.next()));
        }
        return SyntaxDictionary.limitSet(elements, start);
    }

    public Set<Object> getFilteredScopeVars(String start) {
        return SyntaxDictionary.limitSet(this.getAllScopeVars(), start);
    }

    public Set<Object> getFunctionParams(String functionName) {
        Set<String> entries = this.functions.keySet();
        Iterator<String> i = entries.iterator();
        try {
            while (i.hasNext()) {
                Function f;
                String o = i.next();
                if (!(this.functions.get(o) instanceof Function) || !(f = (Function)this.functions.get(o)).getName().equalsIgnoreCase(functionName)) continue;
                return f.getParameters();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Tag getTag(String name) {
        Object obj;
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !name.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionarY::getTag() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + name + "'");
        }
        if ((obj = this.syntaxelements.get(name.toLowerCase())) != null) {
            return (Tag)obj;
        }
        return null;
    }

    public Set<Object> getFilteredAttributeValues(String tag, String attribute, String start) {
        Set<Object> attribs;
        if (tag == null || attribute == null || start == null) {
            throw new IllegalArgumentException("tag, attribute, or start is null");
        }
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !tag.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionarY::getFilteredAttributeValues() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + tag + "'");
        }
        if ((attribs = this.getElementAttributes(tag)) == null) {
            return null;
        }
        if (attribs.size() == 0) {
            return null;
        }
        Object[] tempArray = attribs.toArray();
        for (int i = 0; i < tempArray.length; ++i) {
            Parameter currParam = (Parameter)tempArray[i];
            if (currParam.getName().compareToIgnoreCase(attribute) != 0) continue;
            return SyntaxDictionary.limitSet(currParam.getValues(), start);
        }
        return null;
    }

    public Set<Object> getFilteredAttributes(String tag, String start) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is null");
        }
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !tag.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionarY::getFilteredAttributes() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + tag + "'");
        }
        return SyntaxDictionary.limitSet(this.getElementAttributes(tag), start.toLowerCase());
    }

    public Set<String> getFunctions() {
        return this.functions.keySet();
    }

    public String getFunctionUsage(String functionname) {
        return (String)this.functions.get(functionname.toLowerCase());
    }

    public String getFunctionHelp(String functionname) {
        String helpText = "";
        Object o = this.functions.get(functionname.toLowerCase());
        if (o instanceof Function) {
            Function f = (Function)o;
            helpText = f.getHelp().trim();
        }
        return helpText;
    }

    public Function getFunction(String name) {
        Object obj = this.functions.get(name.toLowerCase());
        if (obj != null) {
            return (Function)obj;
        }
        return null;
    }

    public boolean tagExists(String name) {
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !name.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionarY::tagExists() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + name + "'");
        }
        if (this.syntaxelements == null) {
            return false;
        }
        return this.syntaxelements.containsKey(name.toLowerCase());
    }

    public boolean functionExists(String name) {
        if (this.functions == null) {
            return false;
        }
        return this.functions.containsKey(name.toLowerCase());
    }

    public static Set<Object> limitSet(Set<Object> st, String start) {
        HashSet<Object> filterset = new HashSet<Object>();
        Set<Object> fullset = st;
        if (fullset != null) {
            for (Object item : fullset) {
                String possible2 = "";
                if (item instanceof String) {
                    possible2 = (String)item;
                } else if (item instanceof Tag) {
                    possible2 = ((Tag)item).getName();
                } else if (item instanceof Function) {
                    possible2 = ((Function)item).getName();
                } else if (item instanceof Parameter) {
                    possible2 = ((Parameter)item).getName();
                } else if (item instanceof Value) {
                    possible2 = ((Value)item).getValue();
                } else if (item instanceof ScopeVar) {
                    possible2 = ((ScopeVar)item).getName();
                } else if (item instanceof Component) {
                    for (String possible2 : ((Component)item).getScopes()) {
                        if (possible2.toUpperCase().startsWith(start.toUpperCase())) {
                            ScopeVar val = new ScopeVar("componentscope", possible2);
                            val.setHelp(((Component)item).getHelp());
                            filterset.add(new ScopeVar("componentscope", possible2));
                            continue;
                        }
                        if (!(possible2 + ".").toUpperCase().equals(start.toUpperCase())) continue;
                        Iterator j = ((Component)item).getMethods().iterator();
                        while (j.hasNext()) {
                            filterset.add(j.next());
                        }
                    }
                    possible2 = "";
                } else {
                    throw new IllegalArgumentException("The passed set must have only Strings, Procedures, or Parameters");
                }
                if (start.endsWith("(") && possible2.equalsIgnoreCase(start.substring(0, start.length() - 1))) {
                    filterset.add(item);
                    continue;
                }
                if (!possible2.toUpperCase().startsWith(start.toUpperCase())) continue;
                filterset.add(item);
            }
        }
        return filterset;
    }

    public Set<Object> getElementAttributes(String elementname) {
        if (this.syntaxelements == DictionaryManager.getDictionary("CF_DICTIONARY") && !elementname.toLowerCase().startsWith("cf")) {
            System.err.println("SyntaxDictionarY::getElementAttributes() - WARNING: Tag name requested that does NOT begin with CF. Tag name was '" + elementname + "'");
        }
        try {
            Procedure p = null;
            if (this.syntaxelements.containsKey(elementname.toLowerCase())) {
                p = (Procedure)this.syntaxelements.get(elementname.toLowerCase());
            }
            if (p != null) {
                Set st = p.getParameters();
                return st;
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private void loadDictionary() throws IOException, SAXException, ParserConfigurationException {
        if (this.dictionaryURL == null) {
            throw new IOException("Dictionary file name can not be null!");
        }
        URL url = new URL(this.dictionaryURL);
        URLConnection urlcon = url.openConnection();
        BufferedInputStream xml = new BufferedInputStream(urlcon.getInputStream());
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        xmlReader.setContentHandler(new DictionaryContentHandler(this.syntaxelements, this.functions, this.scopeVars, this.scopes));
        InputSource input = new InputSource(xml);
        input.setSystemId(url.toString());
        xmlReader.parse(input);
    }
}

