/*
 * Decompiled with CFR 0.152.
 */
package cfml.dictionary.syntax;

import cfml.dictionary.ISyntaxDictionary;
import cfml.dictionary.syntax.CFSyntaxDictionary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SQLSyntaxDictionary
extends CFSyntaxDictionary
implements ISyntaxDictionary {
    protected static Set sqlkeywords;

    public SQLSyntaxDictionary() {
        sqlkeywords = new HashSet();
        operators = new HashSet();
        SQLSyntaxDictionary.buildOperatorSyntax();
    }

    public Set getSQLKeywords() {
        return sqlkeywords;
    }

    public void loadKeywords(URL keywordsURL) {
        try {
            if (keywordsURL == null) {
                throw new IOException("Keyword file name cannot be null!");
            }
            InputStream iStream = keywordsURL.openStream();
            BufferedReader fileReader = new BufferedReader(new InputStreamReader(iStream));
            String line = fileReader.readLine();
            ArrayList<String> keywords = new ArrayList<String>();
            while (line != null) {
                keywords.add(line.toLowerCase().trim());
                line = fileReader.readLine();
            }
            this.buildSQLKeywordSyntax(keywords);
        }
        catch (IOException e) {
            System.err.println(keywordsURL);
            e.printStackTrace();
        }
    }

    protected void buildSQLKeywordSyntax(List keywords) {
        for (String word : keywords) {
            sqlkeywords.add(word);
        }
    }
}

