/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.DataFileType;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.frame.InputDataColumn;
import com.github.chen0040.data.frame.OutputDataColumn;
import com.github.chen0040.data.utils.CsvUtils;
import com.github.chen0040.data.utils.NumberUtils;
import com.github.chen0040.data.utils.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQuery {
    public static SourceBuilder libsvm() {
        return new DataFrameBuilderX().libsvm();
    }

    public static SourceBuilder csv(String splitter, boolean skipFirstLine) {
        return new DataFrameBuilderX().csv(splitter, skipFirstLine);
    }

    public static DataTableBuilder blank() {
        return new DataFrameBuilderX().blank();
    }

    private static class DataFrameBuilderX
    implements SourceBuilder,
    DataFrameQueryBuilder,
    DataColumnBuilder,
    FormatBuilder,
    DataTableBuilder {
        private final List<DataFrameColumn> inputColumns = new ArrayList<DataFrameColumn>();
        private final List<DataFrameColumn> outputColumns = new ArrayList<DataFrameColumn>();
        private InputStream dataInputStream;
        private String csvSplitter;
        private DataFileType fileType;
        private boolean skipFirstLine = false;
        private static final Logger logger = LoggerFactory.getLogger(DataFrameBuilderX.class);
        private DataFrameColumn selected = null;

        private DataFrameBuilderX() {
        }

        @Override
        public DataColumnBuilder selectColumn(int columnIndex) {
            this.selected = new DataFrameColumn("", columnIndex, StringUtils::parseDouble);
            return this;
        }

        @Override
        public DataFrame build() {
            BasicDataFrame dataFrame = new BasicDataFrame();
            if (this.fileType == DataFileType.Csv) {
                if (this.inputColumns.isEmpty() || this.outputColumns.isEmpty()) {
                    throw new RuntimeException("data frame should not have either empty input columns or empty output columns");
                }
                CsvUtils.csv(this.dataInputStream, this.csvSplitter, this.skipFirstLine, words -> {
                    DataRow row = dataFrame.newRow();
                    for (int i = 0; i < ((String[])words).length; ++i) {
                        for (DataFrameColumn c : this.inputColumns) {
                            if (c.index != i) continue;
                            row.setCell(c.columnName, NumberUtils.toDouble(c.transformer.apply(words[i])));
                        }
                        for (DataFrameColumn c : this.outputColumns) {
                            if (c.index != i) continue;
                            Object target = c.transformer.apply(words[i]);
                            if (target instanceof String) {
                                row.setCategoricalTargetCell(c.columnName, (String)target);
                                continue;
                            }
                            row.setTargetCell(c.columnName, NumberUtils.toDouble(target));
                        }
                    }
                    dataFrame.addRow(row);
                    return true;
                }, e -> logger.error("Failed to read csv file", (Throwable)e));
            } else if (this.fileType == DataFileType.HeartScale) {
                List<Map<Integer, String>> rows = CsvUtils.readHeartScale(this.dataInputStream);
                if (this.inputColumns.isEmpty() && this.outputColumns.isEmpty()) {
                    for (Map<Integer, String> row : rows) {
                        DataRow newRow = dataFrame.newRow();
                        for (Map.Entry<Integer, String> entry : row.entrySet()) {
                            int columnIndex = entry.getKey();
                            if (columnIndex != 0) {
                                newRow.setCell("" + columnIndex, StringUtils.parseDouble(entry.getValue()));
                                continue;
                            }
                            newRow.setTargetCell("label", StringUtils.parseDouble(entry.getValue()));
                        }
                        dataFrame.addRow(newRow);
                    }
                } else {
                    if (this.inputColumns.isEmpty() || this.outputColumns.isEmpty()) {
                        throw new RuntimeException("data frame should not have either empty input columns or empty output columns");
                    }
                    for (Map<Integer, String> row : rows) {
                        DataRow newRow = dataFrame.newRow();
                        for (DataFrameColumn c : this.inputColumns) {
                            newRow.setCell(c.columnName, NumberUtils.toDouble(c.transformer.apply(row.get(c.index))));
                        }
                        for (DataFrameColumn c : this.outputColumns) {
                            Object target = c.transformer.apply(row.get(c.index));
                            if (target instanceof String) {
                                newRow.setCategoricalTargetCell(c.columnName, (String)target);
                                continue;
                            }
                            newRow.setTargetCell(c.columnName, NumberUtils.toDouble(target));
                        }
                        dataFrame.addRow(newRow);
                    }
                }
            } else if (this.fileType == DataFileType.Memory) {
                dataFrame.getInputColumns().clear();
                dataFrame.getOutputColumns().clear();
                for (DataFrameColumn c : this.inputColumns) {
                    dataFrame.getInputColumns().add(new InputDataColumn(c.columnName));
                }
                for (DataFrameColumn c : this.outputColumns) {
                    dataFrame.getOutputColumns().add(new OutputDataColumn(c.columnName, false));
                }
            }
            if (this.fileType != DataFileType.Memory) {
                dataFrame.lock();
            }
            return dataFrame;
        }

        @Override
        public SourceBuilder csv(String splitter, boolean skipFirstLine) {
            this.skipFirstLine = skipFirstLine;
            this.csvSplitter = splitter;
            this.fileType = DataFileType.Csv;
            return this;
        }

        @Override
        public DataFrameQueryBuilder from(InputStream inputStream) {
            this.dataInputStream = inputStream;
            return this;
        }

        @Override
        public SourceBuilder libsvm() {
            this.fileType = DataFileType.HeartScale;
            return this;
        }

        @Override
        public DataTableBuilder blank() {
            this.fileType = DataFileType.Memory;
            return this;
        }

        @Override
        public DataColumnBuilder transform(Function<String, Object> columnTransformer) {
            this.selected.transformer = columnTransformer;
            return this;
        }

        @Override
        public DataFrameQueryBuilder asInput(String columnName) {
            this.selected.columnName = columnName;
            this.inputColumns.add(this.selected);
            this.selected = null;
            return this;
        }

        @Override
        public DataFrameQueryBuilder asOutput(String columnName) {
            this.selected.columnName = columnName;
            this.outputColumns.add(this.selected);
            this.selected = null;
            return this;
        }

        @Override
        public DataTableBuilder newInput(String columnName) {
            this.inputColumns.add(new DataFrameColumn(columnName, -1, StringUtils::parseDouble));
            return this;
        }

        @Override
        public DataTableBuilder newOutput(String columnName) {
            this.outputColumns.add(new DataFrameColumn(columnName, -1, StringUtils::parseDouble));
            return this;
        }

        @Override
        public DataFrameQueryBuilder end() {
            if (this.inputColumns.isEmpty()) {
                throw new RuntimeException("input columns cannot be empty!");
            }
            if (this.outputColumns.isEmpty()) {
                throw new RuntimeException("output columns cannot be empty!");
            }
            return this;
        }
    }

    private static class DataFrameColumn {
        private int index;
        private Function<String, Object> transformer;
        private String columnName;

        public DataFrameColumn(String columnName, int index, Function<String, Object> transformer) {
            this.columnName = columnName;
            this.index = index;
            this.transformer = transformer;
        }
    }

    public static interface SourceBuilder {
        public DataFrameQueryBuilder from(InputStream var1);
    }

    public static interface DataTableBuilder {
        public DataTableBuilder newInput(String var1);

        public DataTableBuilder newOutput(String var1);

        public DataFrameQueryBuilder end();
    }

    public static interface FormatBuilder {
        public SourceBuilder csv(String var1, boolean var2);

        public SourceBuilder libsvm();

        public DataTableBuilder blank();
    }

    public static interface DataColumnBuilder {
        public DataColumnBuilder transform(Function<String, Object> var1);

        public DataFrameQueryBuilder asInput(String var1);

        public DataFrameQueryBuilder asOutput(String var1);
    }

    public static interface DataFrameQueryBuilder {
        public DataColumnBuilder selectColumn(int var1);

        public DataFrame build();
    }
}

