/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.InputDataColumn;
import com.github.chen0040.data.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class Coefficients {
    private final List<Double> values = new ArrayList<Double>();
    private final List<InputDataColumn> descriptors = new ArrayList<InputDataColumn>();

    public void copy(Coefficients rhs) {
        this.values.clear();
        this.values.addAll(CollectionUtils.clone(rhs.values, x -> x));
        this.descriptors.clear();
        for (int i = 0; i < rhs.descriptors.size(); ++i) {
            this.descriptors.add(rhs.descriptors.get(i).makeCopy());
        }
    }

    public Coefficients makeCopy() {
        Coefficients clone = new Coefficients();
        clone.copy(this);
        return clone;
    }

    public List<Double> getValues() {
        return CollectionUtils.clone(this.values, x -> x);
    }

    public void setValues(List<Double> values) {
        this.values.clear();
        this.values.addAll(CollectionUtils.clone(values, x -> x));
    }

    public List<InputDataColumn> getDescriptors() {
        return CollectionUtils.clone(this.descriptors, InputDataColumn::makeCopy);
    }

    public void setDescriptors(List<InputDataColumn> descriptors) {
        this.descriptors.clear();
        this.descriptors.addAll(CollectionUtils.clone(descriptors, InputDataColumn::makeCopy));
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        if (this.values.isEmpty()) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(String.format("\"(Intercepter)\":%f, ", this.values.get(0)));
        for (int i = 1; i < this.values.size(); ++i) {
            sb.append(String.format(", \"%s\":%f", this.descriptors.get(i - 1).toString(), this.values.get(i)));
        }
        sb.append("}");
        return sb.toString();
    }
}

