/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.frame;

import com.github.chen0040.data.frame.BasicDataRow;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.frame.InputDataColumn;
import com.github.chen0040.data.frame.OutputDataColumn;
import com.github.chen0040.data.utils.CollectionUtils;
import com.github.chen0040.data.utils.TupleTwo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BasicDataFrame
implements DataFrame {
    private final List<DataRow> rows = new ArrayList<DataRow>();
    private final List<InputDataColumn> inputDataColumns = new ArrayList<InputDataColumn>();
    private final List<OutputDataColumn> outputDataColumns = new ArrayList<OutputDataColumn>();
    private boolean locked = false;
    private final Map<String, List<String>> levels = new HashMap<String, List<String>>();

    @Override
    public int rowCount() {
        return this.rows.size();
    }

    @Override
    public DataRow row(int i) {
        return this.rows.get(i);
    }

    @Override
    public List<InputDataColumn> getInputColumns() {
        return this.inputDataColumns;
    }

    @Override
    public List<OutputDataColumn> getOutputColumns() {
        return this.outputDataColumns;
    }

    @Override
    public List<String> rowArrayDescriptors() {
        List numericInputColumns = this.inputDataColumns.stream().filter((? super T c) -> !c.isCategorical()).map(InputDataColumn::getColumnName).collect(Collectors.toList());
        List categoricalInputColumns = this.inputDataColumns.stream().filter(InputDataColumn::isCategorical).map(InputDataColumn::getColumnName).collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(numericInputColumns);
        for (String c2 : categoricalInputColumns) {
            List<String> levelsInFactor = this.levels.get(c2);
            int count = levelsInFactor.size();
            if (count == 2) {
                count = 1;
            }
            for (int j = 0; j < count; ++j) {
                result.add(c2 + ":" + levelsInFactor.get(j));
            }
        }
        return result;
    }

    @Override
    public void unlock() {
        this.locked = false;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void lock() {
        List levelsInFactor;
        Iterator levels;
        Set set;
        HashMap<String, Set<Object>> inputLevels = new HashMap<String, Set<Object>>();
        HashMap<String, Set<String>> outputLevels = new HashMap<String, Set<String>>();
        for (DataRow dataRow : this.rows) {
            Set<String> set2;
            List<String> keys = dataRow.getColumnNames();
            for (String key : keys) {
                if (inputLevels.containsKey(key)) continue;
                HashSet set22 = new HashSet();
                inputLevels.put(key, set22);
            }
            keys = dataRow.getCategoricalColumnNames();
            for (String key : keys) {
                if (inputLevels.containsKey(key)) {
                    set2 = (Set)inputLevels.get(key);
                } else {
                    set2 = new HashSet();
                    inputLevels.put(key, set2);
                }
                set2.add(dataRow.getCategoricalCell(key));
            }
            keys = dataRow.getTargetColumnNames();
            for (String key : keys) {
                if (outputLevels.containsKey(key)) continue;
                set2 = new HashSet();
                outputLevels.put(key, set2);
            }
            keys = dataRow.getCategoricalTargetColumnNames();
            for (String key : keys) {
                if (outputLevels.containsKey(key)) {
                    set2 = (Set)outputLevels.get(key);
                } else {
                    set2 = new HashSet();
                    outputLevels.put(key, set2);
                }
                set2.add(dataRow.getCategoricalTargetCell(key));
            }
        }
        this.inputDataColumns.clear();
        for (Map.Entry entry : inputLevels.entrySet()) {
            set = (Set)entry.getValue();
            InputDataColumn inputDataColumn = new InputDataColumn();
            inputDataColumn.setColumnName((String)entry.getKey());
            levels = set.stream().collect(Collectors.toList());
            levels.sort(String::compareTo);
            inputDataColumn.setLevels((List<String>)((Object)levels));
            this.inputDataColumns.add(inputDataColumn);
        }
        this.outputDataColumns.clear();
        for (Map.Entry entry : outputLevels.entrySet()) {
            set = (Set)entry.getValue();
            OutputDataColumn outputDataColumn = new OutputDataColumn();
            outputDataColumn.setColumnName((String)entry.getKey());
            levels = set.stream().collect(Collectors.toList());
            levels.sort(String::compareTo);
            outputDataColumn.setLevels((List<String>)((Object)levels));
            this.outputDataColumns.add(outputDataColumn);
        }
        this.inputDataColumns.sort((a, b) -> a.getColumnName().compareTo(b.getColumnName()));
        this.outputDataColumns.sort((a, b) -> a.getColumnName().compareTo(b.getColumnName()));
        List<String> numericInputColumns = this.inputDataColumns.stream().filter((? super T c) -> !c.isCategorical()).map(InputDataColumn::getColumnName).collect(Collectors.toList());
        List<String> list = this.inputDataColumns.stream().filter(InputDataColumn::isCategorical).map(InputDataColumn::getColumnName).collect(Collectors.toList());
        List<String> numericOutputColumns = this.outputDataColumns.stream().filter((? super T c) -> !c.isCategorical()).map(OutputDataColumn::getColumnName).collect(Collectors.toList());
        List<String> categoricalOutputColumns = this.outputDataColumns.stream().filter(OutputDataColumn::isCategorical).map(OutputDataColumn::getColumnName).collect(Collectors.toList());
        numericInputColumns.sort(String::compareTo);
        list.sort(String::compareTo);
        numericOutputColumns.sort(String::compareTo);
        categoricalOutputColumns.sort(String::compareTo);
        this.levels.clear();
        for (Map.Entry entry : inputLevels.entrySet()) {
            levelsInFactor = ((Set)entry.getValue()).stream().collect(Collectors.toList());
            levelsInFactor.sort(String::compareTo);
            this.levels.put((String)entry.getKey(), levelsInFactor);
        }
        for (Map.Entry entry : outputLevels.entrySet()) {
            levelsInFactor = ((Set)entry.getValue()).stream().collect(Collectors.toList());
            levelsInFactor.sort(String::compareTo);
            this.levels.put((String)entry.getKey(), levelsInFactor);
        }
        for (int i = 0; i < this.rowCount(); ++i) {
            DataRow row = this.row(i);
            row.setColumnNames(numericInputColumns);
            row.setCategoricalColumnNames(list);
            row.setTargetColumnNames(numericOutputColumns);
            row.setCategoricalTargetColumnNames(categoricalOutputColumns);
            row.setLevels(this.levels);
        }
        this.locked = true;
    }

    @Override
    public DataRow newRow() {
        return new BasicDataRow();
    }

    @Override
    public void addRow(DataRow row) {
        if (this.locked) {
            throw new RuntimeException("Data frame is currently locked, please unlock first");
        }
        this.rows.add(row);
    }

    @Override
    public String head(int limit) {
        StringBuilder sb = new StringBuilder();
        int max = Math.min(limit, this.rowCount());
        for (int i = 0; i < max; ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append(this.row(i));
        }
        return sb.toString();
    }

    @Override
    public DataFrame shuffle() {
        Random random = new Random(System.currentTimeMillis());
        for (int i = 1; i < this.rows.size(); ++i) {
            int j = random.nextInt(i + 1);
            CollectionUtils.exchange(this.rows, i, j);
        }
        return this;
    }

    @Override
    public TupleTwo<DataFrame, DataFrame> split(double ratio) {
        int i;
        assert (this.locked);
        BasicDataFrame frame1 = new BasicDataFrame();
        BasicDataFrame frame2 = new BasicDataFrame();
        frame1.inputDataColumns.addAll(this.inputDataColumns.stream().map(InputDataColumn::makeCopy).collect(Collectors.toList()));
        frame2.inputDataColumns.addAll(this.inputDataColumns.stream().map(InputDataColumn::makeCopy).collect(Collectors.toList()));
        frame1.outputDataColumns.addAll(this.outputDataColumns.stream().map(OutputDataColumn::makeCopy).collect(Collectors.toList()));
        frame2.outputDataColumns.addAll(this.outputDataColumns.stream().map(OutputDataColumn::makeCopy).collect(Collectors.toList()));
        int split = (int)((double)this.rows.size() * ratio);
        for (i = 0; i < split; ++i) {
            frame1.addRow(this.rows.get(i).makeCopy());
        }
        for (i = split; i < this.rows.size(); ++i) {
            frame2.addRow(this.rows.get(i).makeCopy());
        }
        return new TupleTwo<DataFrame, DataFrame>(frame1, frame2);
    }

    @Override
    public Stream<DataRow> stream() {
        return this.rows.stream();
    }

    @Override
    public DataFrame makeCopy() {
        BasicDataFrame clone = new BasicDataFrame();
        clone.copy(this);
        return clone;
    }

    private void copy(DataFrame that) {
        this.rows.clear();
        this.inputDataColumns.clear();
        this.outputDataColumns.clear();
        this.levels.clear();
        this.unlock();
        for (DataRow dataRow : that.rows()) {
            DataRow newRow = this.newRow();
            newRow.copy(dataRow);
            this.addRow(dataRow);
        }
        this.lock();
    }

    @Override
    public DataFrame filter(Predicate<DataRow> predicate) {
        BasicDataFrame clone = new BasicDataFrame();
        for (DataRow row : this.rows) {
            if (!predicate.test(row)) continue;
            DataRow newRow = clone.newRow();
            newRow.copy(row);
        }
        clone.lock();
        return clone;
    }

    @Override
    public Iterable<? extends DataRow> rows() {
        return this.rows;
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.rows.iterator();
    }
}

