/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.image;

import com.github.chen0040.data.frame.BasicDataFrame;
import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.image.ImageDataRow;
import java.awt.image.BufferedImage;
import java.util.Random;

public class ImageDataFrameFactory {
    private static Random rand = new Random();

    public static int get_rgb(int alpha, int r, int g, int b) {
        return alpha << 24 | r << 16 | g << 8 | b;
    }

    public static int get_r(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int get_b(int rgb) {
        return rgb & 0xFF;
    }

    public static int get_g(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int get_luminance(int r, int g, int b) {
        return (int)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
    }

    public static int get_luminance(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int gray = ImageDataFrameFactory.get_luminance(r, g, b);
        return gray;
    }

    public static DataRow getPixelTuple(int x, int y, int rgb) {
        ImageDataRow row = new ImageDataRow();
        row.setPixelX(x);
        row.setPixelY(y);
        double r = ImageDataFrameFactory.get_r(rgb);
        double g = ImageDataFrameFactory.get_g(rgb);
        double b = ImageDataFrameFactory.get_b(rgb);
        double l = ImageDataFrameFactory.get_luminance(rgb);
        row.setCell("r", r);
        row.setCell("g", g);
        row.setCell("b", b);
        row.setCell("l", l);
        return row;
    }

    public static DataFrame dataFrame(BufferedImage img) {
        BasicDataFrame batch = new BasicDataFrame();
        for (int i = 0; i < 3000; ++i) {
            int x = rand.nextInt(img.getWidth());
            int y = rand.nextInt(img.getHeight());
            int rgb = img.getRGB(x, y);
            DataRow row = ImageDataFrameFactory.getPixelTuple(x, y, rgb);
            batch.addRow(row);
        }
        batch.lock();
        return batch;
    }
}

