/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.data.text;

import com.github.chen0040.data.text.TextFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PunctuationFilter
implements TextFilter,
Serializable {
    private static final long serialVersionUID = 7117721387713659243L;
    private String filter = "-{}[]";
    private List<String> stripFilter = new ArrayList<String>();

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getStripFilter() {
        return this.stripFilter;
    }

    public void setStripFilter(List<String> stripFilter) {
        this.stripFilter = stripFilter;
    }

    public PunctuationFilter() {
        this.stripFilter.add("\\{");
        this.stripFilter.add("\\}");
        this.stripFilter.add("\\[");
        this.stripFilter.add("\\]");
        this.stripFilter.add("\\(");
        this.stripFilter.add("\\)");
    }

    @Override
    public List<String> filter(List<String> words) {
        ArrayList<String> result = new ArrayList<String>();
        for (String word : words) {
            if (this.isPunctuation(word)) continue;
            result.add(this.strip(word));
        }
        return result;
    }

    private boolean isPunctuation(String w) {
        if ((w = w.trim()).length() > 1) {
            return false;
        }
        return this.filter.contains(w);
    }

    private String strip(String word) {
        for (int i = 0; i < this.stripFilter.size(); ++i) {
            word = word.replaceAll(this.stripFilter.get(i), "");
        }
        return word;
    }

    public Object clone() {
        PunctuationFilter clone = new PunctuationFilter();
        clone.copy(this);
        return clone;
    }

    public void copy(PunctuationFilter rhs) {
        this.stripFilter.clear();
        this.stripFilter.addAll(rhs.stripFilter);
        this.filter = rhs.filter;
    }
}

