/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp;

import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.lgp.enums.LGPCrossoverStrategy;
import com.github.chen0040.gp.lgp.enums.LGPInitializationStrategy;
import com.github.chen0040.gp.lgp.enums.LGPReplacementStrategy;
import com.github.chen0040.gp.lgp.gp.Population;
import com.github.chen0040.gp.lgp.program.Operator;
import com.github.chen0040.gp.lgp.program.OperatorSet;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.lgp.program.operators.Divide;
import com.github.chen0040.gp.lgp.program.operators.Minus;
import com.github.chen0040.gp.lgp.program.operators.Multiply;
import com.github.chen0040.gp.lgp.program.operators.Plus;
import com.github.chen0040.gp.lgp.program.operators.Power;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.services.SimpleRandEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class LGP {
    public static final double DEFAULT_UNDEFINED_LOW = 1.0;
    private boolean useUndefinedLow = true;
    private double regPosInf = 1.0E7;
    private double regNegInf = -1.0E7;
    private double undefinedLow = 1.0;
    private double undefinedHigh = 1000000.0;
    private RandEngine randEngine = new SimpleRandEngine();
    private int registerCount;
    private List<Double> constants = new ArrayList<Double>();
    private List<Double> constantWeights = new ArrayList<Double>();
    private OperatorSet operatorSet = new OperatorSet();
    private int maxGeneration = 1000;
    private int populationSize = 1000;
    private LGPInitializationStrategy programInitializationStrategy = LGPInitializationStrategy.VariableLength;
    private int popInitConstantProgramLength = 10;
    private int popInitMaxProgramLength = 15;
    private int popInitMinProgramLength = 5;
    private double crossoverRate = 0.1;
    private LGPCrossoverStrategy crossoverStrategy = LGPCrossoverStrategy.Linear;
    private int maxProgramLength = 100;
    private int minProgramLength = 20;
    private int maxSegmentLength = 10;
    private int maxDistanceOfCrossoverPoints = 10;
    private int maxDifferenceOfSegmentLength = 5;
    private double insertionProbability = 0.5;
    private double macroMutationRate = 0.75;
    private double microMutateConstantStandardDeviation = 1.0;
    private double microMutateOperatorRate = 0.5;
    private double microMutateRegisterRate = 0.5;
    private double microMutateConstantRate = 0.5;
    private double microMutationRate = 0.25;
    private boolean effectiveMutation = false;
    private double macroMutateInsertionRate = 0.5;
    private double macroMutateDeletionRate = 0.5;
    private int macroMutateMaxProgramLength = 100;
    private int macroMutateMinProgramLength = 20;
    private List<Observation> observations = new ArrayList<Observation>();
    private BiFunction<Program, List<Observation>, Double> costEvaluator;
    private LGPReplacementStrategy replacementStrategy = LGPReplacementStrategy.ProbabilisticReplacement;
    private double replacementProbability = 1.0;
    private int displayEvery = -1;

    public double undefined() {
        if (this.useUndefinedLow) {
            return this.undefinedLow;
        }
        return this.undefinedHigh;
    }

    public double constantWeight(int index) {
        if (index >= this.constantWeights.size()) {
            return 1.0;
        }
        return this.constantWeights.get(index);
    }

    public double constant(int index) {
        return this.constants.get(index);
    }

    public double evaluateCost(Program program) {
        program.markStructuralIntrons(this);
        if (this.costEvaluator != null) {
            return this.costEvaluator.apply(program.makeEffectiveCopy(), this.observations);
        }
        throw new RuntimeException("Cost evaluator for the linear program is not specified!");
    }

    public Population newPopulation() {
        return new Population(this);
    }

    public void addConstant(double constant, double weight) {
        this.constants.add(constant);
        this.constantWeights.add(weight);
    }

    public Program fit(List<Observation> observations) {
        this.observations.clear();
        this.observations.addAll(observations);
        long startTime = System.currentTimeMillis();
        Population pop = this.newPopulation();
        pop.initialize();
        while (!pop.isTerminated()) {
            pop.evolve();
            if (this.displayEvery <= 0 || pop.getCurrentGeneration() % this.displayEvery != 0) continue;
            long seconds = (System.currentTimeMillis() - startTime) / 1000L;
            System.out.println("Generation: " + pop.getCurrentGeneration() + " (Pop: " + pop.size() + "), elapsed: " + seconds + " seconds");
            System.out.println("Global Cost: " + pop.getGlobalBestProgram().getCost() + "\tCurrent Cost: " + pop.getCostInCurrentGeneration());
        }
        return pop.getGlobalBestProgram();
    }

    public void addConstants(double ... constants) {
        for (int i = 0; i < constants.length; ++i) {
            this.addConstant(constants[i], 1.0);
        }
    }

    public static LGP defaultConfig() {
        LGP lgp = new LGP();
        lgp.getOperatorSet().addAll(new Operator[]{new Plus(), new Minus(), new Divide(), new Multiply(), new Power()});
        lgp.getOperatorSet().addIfLessThanOperator();
        lgp.addConstants(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
        return lgp;
    }

    public boolean isUseUndefinedLow() {
        return this.useUndefinedLow;
    }

    public double getRegPosInf() {
        return this.regPosInf;
    }

    public double getRegNegInf() {
        return this.regNegInf;
    }

    public double getUndefinedLow() {
        return this.undefinedLow;
    }

    public double getUndefinedHigh() {
        return this.undefinedHigh;
    }

    public RandEngine getRandEngine() {
        return this.randEngine;
    }

    public int getRegisterCount() {
        return this.registerCount;
    }

    public List<Double> getConstants() {
        return this.constants;
    }

    public List<Double> getConstantWeights() {
        return this.constantWeights;
    }

    public OperatorSet getOperatorSet() {
        return this.operatorSet;
    }

    public int getMaxGeneration() {
        return this.maxGeneration;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public LGPInitializationStrategy getProgramInitializationStrategy() {
        return this.programInitializationStrategy;
    }

    public int getPopInitConstantProgramLength() {
        return this.popInitConstantProgramLength;
    }

    public int getPopInitMaxProgramLength() {
        return this.popInitMaxProgramLength;
    }

    public int getPopInitMinProgramLength() {
        return this.popInitMinProgramLength;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public LGPCrossoverStrategy getCrossoverStrategy() {
        return this.crossoverStrategy;
    }

    public int getMaxProgramLength() {
        return this.maxProgramLength;
    }

    public int getMinProgramLength() {
        return this.minProgramLength;
    }

    public int getMaxSegmentLength() {
        return this.maxSegmentLength;
    }

    public int getMaxDistanceOfCrossoverPoints() {
        return this.maxDistanceOfCrossoverPoints;
    }

    public int getMaxDifferenceOfSegmentLength() {
        return this.maxDifferenceOfSegmentLength;
    }

    public double getInsertionProbability() {
        return this.insertionProbability;
    }

    public double getMacroMutationRate() {
        return this.macroMutationRate;
    }

    public double getMicroMutateConstantStandardDeviation() {
        return this.microMutateConstantStandardDeviation;
    }

    public double getMicroMutateOperatorRate() {
        return this.microMutateOperatorRate;
    }

    public double getMicroMutateRegisterRate() {
        return this.microMutateRegisterRate;
    }

    public double getMicroMutateConstantRate() {
        return this.microMutateConstantRate;
    }

    public double getMicroMutationRate() {
        return this.microMutationRate;
    }

    public boolean isEffectiveMutation() {
        return this.effectiveMutation;
    }

    public double getMacroMutateInsertionRate() {
        return this.macroMutateInsertionRate;
    }

    public double getMacroMutateDeletionRate() {
        return this.macroMutateDeletionRate;
    }

    public int getMacroMutateMaxProgramLength() {
        return this.macroMutateMaxProgramLength;
    }

    public int getMacroMutateMinProgramLength() {
        return this.macroMutateMinProgramLength;
    }

    public List<Observation> getObservations() {
        return this.observations;
    }

    public BiFunction<Program, List<Observation>, Double> getCostEvaluator() {
        return this.costEvaluator;
    }

    public LGPReplacementStrategy getReplacementStrategy() {
        return this.replacementStrategy;
    }

    public double getReplacementProbability() {
        return this.replacementProbability;
    }

    public int getDisplayEvery() {
        return this.displayEvery;
    }

    public void setUseUndefinedLow(boolean useUndefinedLow) {
        this.useUndefinedLow = useUndefinedLow;
    }

    public void setRegPosInf(double regPosInf) {
        this.regPosInf = regPosInf;
    }

    public void setRegNegInf(double regNegInf) {
        this.regNegInf = regNegInf;
    }

    public void setUndefinedLow(double undefinedLow) {
        this.undefinedLow = undefinedLow;
    }

    public void setUndefinedHigh(double undefinedHigh) {
        this.undefinedHigh = undefinedHigh;
    }

    public void setRandEngine(RandEngine randEngine) {
        this.randEngine = randEngine;
    }

    public void setRegisterCount(int registerCount) {
        this.registerCount = registerCount;
    }

    public void setOperatorSet(OperatorSet operatorSet) {
        this.operatorSet = operatorSet;
    }

    public void setMaxGeneration(int maxGeneration) {
        this.maxGeneration = maxGeneration;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void setProgramInitializationStrategy(LGPInitializationStrategy programInitializationStrategy) {
        this.programInitializationStrategy = programInitializationStrategy;
    }

    public void setPopInitConstantProgramLength(int popInitConstantProgramLength) {
        this.popInitConstantProgramLength = popInitConstantProgramLength;
    }

    public void setPopInitMaxProgramLength(int popInitMaxProgramLength) {
        this.popInitMaxProgramLength = popInitMaxProgramLength;
    }

    public void setPopInitMinProgramLength(int popInitMinProgramLength) {
        this.popInitMinProgramLength = popInitMinProgramLength;
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public void setCrossoverStrategy(LGPCrossoverStrategy crossoverStrategy) {
        this.crossoverStrategy = crossoverStrategy;
    }

    public void setMaxProgramLength(int maxProgramLength) {
        this.maxProgramLength = maxProgramLength;
    }

    public void setMinProgramLength(int minProgramLength) {
        this.minProgramLength = minProgramLength;
    }

    public void setMaxSegmentLength(int maxSegmentLength) {
        this.maxSegmentLength = maxSegmentLength;
    }

    public void setMaxDistanceOfCrossoverPoints(int maxDistanceOfCrossoverPoints) {
        this.maxDistanceOfCrossoverPoints = maxDistanceOfCrossoverPoints;
    }

    public void setMaxDifferenceOfSegmentLength(int maxDifferenceOfSegmentLength) {
        this.maxDifferenceOfSegmentLength = maxDifferenceOfSegmentLength;
    }

    public void setInsertionProbability(double insertionProbability) {
        this.insertionProbability = insertionProbability;
    }

    public void setMacroMutationRate(double macroMutationRate) {
        this.macroMutationRate = macroMutationRate;
    }

    public void setMicroMutateConstantStandardDeviation(double microMutateConstantStandardDeviation) {
        this.microMutateConstantStandardDeviation = microMutateConstantStandardDeviation;
    }

    public void setMicroMutateOperatorRate(double microMutateOperatorRate) {
        this.microMutateOperatorRate = microMutateOperatorRate;
    }

    public void setMicroMutateRegisterRate(double microMutateRegisterRate) {
        this.microMutateRegisterRate = microMutateRegisterRate;
    }

    public void setMicroMutateConstantRate(double microMutateConstantRate) {
        this.microMutateConstantRate = microMutateConstantRate;
    }

    public void setMicroMutationRate(double microMutationRate) {
        this.microMutationRate = microMutationRate;
    }

    public void setEffectiveMutation(boolean effectiveMutation) {
        this.effectiveMutation = effectiveMutation;
    }

    public void setMacroMutateInsertionRate(double macroMutateInsertionRate) {
        this.macroMutateInsertionRate = macroMutateInsertionRate;
    }

    public void setMacroMutateDeletionRate(double macroMutateDeletionRate) {
        this.macroMutateDeletionRate = macroMutateDeletionRate;
    }

    public void setMacroMutateMaxProgramLength(int macroMutateMaxProgramLength) {
        this.macroMutateMaxProgramLength = macroMutateMaxProgramLength;
    }

    public void setMacroMutateMinProgramLength(int macroMutateMinProgramLength) {
        this.macroMutateMinProgramLength = macroMutateMinProgramLength;
    }

    public void setObservations(List<Observation> observations) {
        this.observations = observations;
    }

    public void setCostEvaluator(BiFunction<Program, List<Observation>, Double> costEvaluator) {
        this.costEvaluator = costEvaluator;
    }

    public void setReplacementStrategy(LGPReplacementStrategy replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
    }

    public void setReplacementProbability(double replacementProbability) {
        this.replacementProbability = replacementProbability;
    }

    public void setDisplayEvery(int displayEvery) {
        this.displayEvery = displayEvery;
    }
}

