/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.helpers.InstructionHelper;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.lgp.program.Register;
import com.github.chen0040.gp.services.RandEngine;
import java.util.HashSet;
import java.util.List;

public class MacroMutation {
    public static void apply(Program child, LGP manager, RandEngine randEngine) {
        double r = randEngine.uniform();
        List<Instruction> instructions = child.getInstructions();
        if (child.length() < manager.getMacroMutateMaxProgramLength() && (r < manager.getMacroMutateInsertionRate() || child.length() == manager.getMacroMutateMinProgramLength())) {
            Instruction inserted_instruction = new Instruction();
            InstructionHelper.initialize(inserted_instruction, child, randEngine);
            int loc = randEngine.nextInt(child.length());
            if (loc == child.length() - 1) {
                instructions.add(inserted_instruction);
            } else {
                instructions.add(loc, inserted_instruction);
            }
            if (manager.isEffectiveMutation()) {
                while (loc < instructions.size() && instructions.get(loc).getOperator().isConditionalConstruct()) {
                    ++loc;
                }
                if (loc < instructions.size()) {
                    HashSet<Integer> Reff = new HashSet<Integer>();
                    child.markStructuralIntrons(loc, Reff, manager);
                    if (Reff.size() > 0) {
                        int iRegisterIndex = -1;
                        for (Integer Reff_value : Reff) {
                            if (iRegisterIndex == -1) {
                                iRegisterIndex = Reff_value;
                                continue;
                            }
                            if (!(randEngine.uniform() < 0.5)) continue;
                            iRegisterIndex = Reff_value;
                        }
                        instructions.get(loc).setTargetOperand((Register)child.getRegisterSet().get(iRegisterIndex));
                    }
                }
            }
        } else if (child.length() > manager.getMacroMutateMinProgramLength() && (r > manager.getMacroMutateInsertionRate() || child.length() == manager.getMacroMutateMaxProgramLength())) {
            int loc = randEngine.nextInt(instructions.size());
            if (manager.isEffectiveMutation()) {
                for (int i = 0; i < 10 && instructions.get(loc = randEngine.nextInt(instructions.size())).isStructuralIntron(); ++i) {
                }
            }
            instructions.remove(loc);
        }
        child.invalidateCost();
    }
}

