/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.data.utils.TupleTwo;
import com.github.chen0040.gp.commons.TournamentSelection;
import com.github.chen0040.gp.commons.TournamentSelectionResult;
import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.gp.Crossover;
import com.github.chen0040.gp.lgp.gp.MacroMutation;
import com.github.chen0040.gp.lgp.gp.MicroMutation;
import com.github.chen0040.gp.lgp.gp.PopulationInitialization;
import com.github.chen0040.gp.lgp.gp.Replacement;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Population {
    private Optional<Program> globalBestProgram = Optional.empty();
    private List<Program> programs = new ArrayList<Program>();
    private int currentGeneration = 0;
    private final LGP manager;
    private Program bestProgramInCurrentGeneration = null;

    public Population(LGP manager) {
        this.manager = manager;
    }

    protected void evaluate() {
        double bestCost = Double.MAX_VALUE;
        for (int i = 0; i < this.programs.size(); ++i) {
            Program p = this.programs.get(i);
            double cost = this.manager.evaluateCost(p);
            p.setCost(cost);
            p.setCostValid(true);
            if (!(p.getCost() < bestCost)) continue;
            this.bestProgramInCurrentGeneration = p;
            bestCost = p.getCost();
        }
        this.updateGlobal(this.bestProgramInCurrentGeneration);
    }

    public void initialize() {
        PopulationInitialization.apply(this.programs, this.manager);
        this.evaluate();
    }

    private void updateGlobal(Program lgp) {
        if (!this.globalBestProgram.isPresent() || CollectionUtils.isBetterThan(lgp, (Comparable)this.globalBestProgram.get())) {
            this.globalBestProgram = Optional.of(lgp.makeEffectiveCopy());
        }
    }

    public boolean isTerminated() {
        return this.currentGeneration >= this.manager.getMaxGeneration();
    }

    public void evolve() {
        RandEngine randEngine = this.manager.getRandEngine();
        int iPopSize = this.manager.getPopulationSize();
        int program_count = 0;
        int computationBudget = iPopSize * 8;
        for (int counter = 0; program_count < iPopSize && counter < computationBudget; ++counter) {
            TournamentSelectionResult<Program> tournament = TournamentSelection.select(this.programs, randEngine);
            TupleTwo<Program, Program> tournament_winners = tournament.getWinners();
            TupleTwo<Program, Program> tournament_losers = tournament.getLosers();
            Program tp1 = ((Program)tournament_winners._1()).makeCopy();
            Program tp2 = ((Program)tournament_winners._2()).makeCopy();
            double r = randEngine.uniform();
            if (r < this.manager.getCrossoverRate()) {
                Crossover.apply(tp1, tp2, this.manager, randEngine);
            }
            if ((r = randEngine.uniform()) < this.manager.getMacroMutationRate()) {
                MacroMutation.apply(tp1, this.manager, randEngine);
            }
            if ((r = randEngine.uniform()) < this.manager.getMacroMutationRate()) {
                MacroMutation.apply(tp2, this.manager, randEngine);
            }
            if ((r = randEngine.uniform()) < this.manager.getMicroMutationRate()) {
                MicroMutation.apply(tp1, this.manager, randEngine);
            }
            if ((r = randEngine.uniform()) < this.manager.getMicroMutationRate()) {
                MicroMutation.apply(tp2, this.manager, randEngine);
            }
            tp1.setCost(this.manager.evaluateCost(tp1));
            tp1.setCostValid(true);
            tp2.setCost(this.manager.evaluateCost(tp2));
            tp2.setCostValid(true);
            Program loser1 = Replacement.compete(this.programs, (Program)tournament_losers._1(), tp1, this.manager, randEngine);
            Program loser2 = Replacement.compete(this.programs, (Program)tournament_losers._2(), tp2, this.manager, randEngine);
            if (loser1 == tournament_losers._1()) {
                ++program_count;
            }
            if (loser2 != tournament_losers._2()) continue;
            ++program_count;
        }
        double bestCost = Double.MAX_VALUE;
        for (int i = 0; i < this.programs.size(); ++i) {
            Program p = this.programs.get(i);
            if (!(p.getCost() < bestCost)) continue;
            this.bestProgramInCurrentGeneration = p;
            bestCost = p.getCost();
        }
        this.updateGlobal(this.bestProgramInCurrentGeneration);
        ++this.currentGeneration;
    }

    public Program getGlobalBestProgram() {
        return this.globalBestProgram.get();
    }

    public double getCostInCurrentGeneration() {
        return this.bestProgramInCurrentGeneration.getCost();
    }

    public int size() {
        return this.programs.size();
    }

    public List<Program> getPrograms() {
        return this.programs;
    }

    public int getCurrentGeneration() {
        return this.currentGeneration;
    }

    public LGP getManager() {
        return this.manager;
    }

    public Program getBestProgramInCurrentGeneration() {
        return this.bestProgramInCurrentGeneration;
    }

    public void setPrograms(List<Program> programs) {
        this.programs = programs;
    }

    public void setCurrentGeneration(int currentGeneration) {
        this.currentGeneration = currentGeneration;
    }

    public void setBestProgramInCurrentGeneration(Program bestProgramInCurrentGeneration) {
        this.bestProgramInCurrentGeneration = bestProgramInCurrentGeneration;
    }
}

