/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.data.exceptions.NotImplementedException;
import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.enums.LGPInitializationStrategy;
import com.github.chen0040.gp.lgp.helpers.InstructionHelper;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.Operator;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.lgp.program.Register;
import com.github.chen0040.gp.services.RandEngine;
import java.util.List;

public class PopulationInitialization {
    public static void apply(List<Program> programs, LGP manager) {
        RandEngine randEngine = manager.getRandEngine();
        if (manager.getProgramInitializationStrategy() == LGPInitializationStrategy.ConstantLength) {
            PopulationInitialization.initializeWithConstantLength(programs, manager, randEngine);
        } else if (manager.getProgramInitializationStrategy() == LGPInitializationStrategy.VariableLength) {
            PopulationInitialization.initializeWithVariableLength(programs, manager, randEngine);
        } else {
            throw new NotImplementedException();
        }
    }

    private static void initializeWithVariableLength(List<Program> programs, LGP manager, RandEngine randEngine) {
        int popSize = manager.getPopulationSize();
        for (int i = 0; i < popSize; ++i) {
            Program lgp = new Program();
            PopulationInitialization.initialize(lgp, manager, randEngine, randEngine.nextInt(manager.getPopInitMinProgramLength(), manager.getPopInitMaxProgramLength()));
            programs.add(lgp);
        }
    }

    private static void initializeWithConstantLength(List<Program> programs, LGP manager, RandEngine randEngine) {
        int popSize = manager.getPopulationSize();
        for (int i = 0; i < popSize; ++i) {
            Program lgp = new Program();
            PopulationInitialization.initialize(lgp, manager, randEngine, manager.getPopInitConstantProgramLength());
            programs.add(lgp);
        }
    }

    private static void initialize(Program program, LGP programManager, RandEngine randEngine, int instructionCount) {
        int i;
        int constantCount = programManager.getConstants().size();
        for (int i2 = 0; i2 < constantCount; ++i2) {
            program.getConstantSet().add(programManager.constant(i2), programManager.constantWeight(i2));
        }
        int registerCount = programManager.getRegisterCount();
        for (int i3 = 0; i3 < registerCount; ++i3) {
            program.getRegisterSet().add(new Register(), 1.0);
        }
        int operatorCount = programManager.getOperatorSet().size();
        for (i = 0; i < operatorCount; ++i) {
            Operator operator = (Operator)programManager.getOperatorSet().get(i);
            program.getOperatorSet().add(operator, programManager.getOperatorSet().getWeight(i));
        }
        for (i = 0; i < instructionCount; ++i) {
            Instruction instruction = new Instruction();
            InstructionHelper.initialize(instruction, program, randEngine);
            program.getInstructions().add(instruction);
        }
    }
}

