/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.helpers;

import com.github.chen0040.gp.lgp.program.ConstantSet;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.Operator;
import com.github.chen0040.gp.lgp.program.OperatorSet;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.lgp.program.Register;
import com.github.chen0040.gp.lgp.program.RegisterSet;
import com.github.chen0040.gp.services.RandEngine;

public class InstructionHelper {
    public static void mutateConstant(Instruction instruction, RandEngine randEngine, double sd) {
        if (instruction.getOperand1().isConstant()) {
            instruction.getOperand1().mutate(randEngine, sd);
        } else {
            instruction.getOperand2().mutate(randEngine, sd);
        }
    }

    public static void mutateOperator(Program program, Instruction instruction, RandEngine randEngine) {
        instruction.setOperator((Operator)program.getOperatorSet().any(randEngine));
    }

    public static void mutateRegister(Program program, Instruction instruction, RandEngine randEngine) {
        InstructionHelper.mutateRegister(program, instruction, randEngine, 0.5);
    }

    public static Instruction reassign2Program(Instruction instruction, Program program) {
        instruction.setOperator((Operator)program.getOperatorSet().get(instruction.getOperator().getIndex()));
        if (instruction.getOperand1().isConstant()) {
            instruction.setOperand1((Register)program.getConstantSet().get(instruction.getOperand1().getIndex()));
        } else {
            instruction.setOperand1((Register)program.getRegisterSet().get(instruction.getOperand1().getIndex()));
        }
        if (instruction.getOperand2().isConstant()) {
            instruction.setOperand2((Register)program.getConstantSet().get(instruction.getOperand2().getIndex()));
        } else {
            instruction.setOperand2((Register)program.getRegisterSet().get(instruction.getOperand2().getIndex()));
        }
        return instruction;
    }

    public static void initialize(Instruction instruction, Program program, RandEngine randEngine) {
        instruction.setOperator((Operator)program.getOperatorSet().any(randEngine));
        double p_const = 0.5;
        double r = randEngine.uniform();
        if (r < p_const) {
            instruction.setOperand1((Register)program.getConstantSet().any(randEngine));
        } else {
            instruction.setOperand1((Register)program.getRegisterSet().any(randEngine));
        }
        if (instruction.getOperand1().isConstant()) {
            instruction.setOperand2((Register)program.getRegisterSet().any(randEngine));
        } else {
            r = randEngine.uniform();
            if (r < p_const) {
                instruction.setOperand2((Register)program.getConstantSet().any(randEngine));
            } else {
                instruction.setOperand2((Register)program.getRegisterSet().any(randEngine));
            }
        }
        instruction.setTargetOperand((Register)program.getRegisterSet().any(randEngine));
    }

    public static void mutateRegister(Program program, Instruction instruction, RandEngine randEngine, double p_const) {
        double r = randEngine.uniform();
        if (r < 0.5) {
            instruction.setTargetOperand(program.getRegisterSet().anyOther(instruction.getTargetOperand(), randEngine));
        } else {
            Register arg2;
            Register arg1;
            r = randEngine.uniform();
            if (r < 0.5) {
                arg1 = instruction.getOperand1();
                arg2 = instruction.getOperand2();
            } else {
                arg1 = instruction.getOperand2();
                arg2 = instruction.getOperand1();
            }
            arg1 = arg2.isConstant() ? (Register)program.getRegisterSet().any(randEngine) : ((r = randEngine.uniform()) < p_const ? (Register)program.getConstantSet().any(randEngine) : (Register)program.getRegisterSet().any(randEngine));
            instruction.setOperand1(arg1);
            instruction.setOperand2(arg2);
        }
    }

    public static Instruction makeCopy(Instruction that, RegisterSet registerSet, ConstantSet constantSet, OperatorSet operatorSet) {
        Instruction clone = new Instruction();
        if (that.getOperand1().isConstant()) {
            clone.setOperand1((Register)constantSet.get(that.getOperand1().getIndex()));
        } else {
            clone.setOperand1((Register)registerSet.get(that.getOperand1().getIndex()));
        }
        if (that.getOperand2().isConstant()) {
            clone.setOperand2((Register)constantSet.get(that.getOperand2().getIndex()));
        } else {
            clone.setOperand2((Register)registerSet.get(that.getOperand2().getIndex()));
        }
        clone.setOperator((Operator)operatorSet.get(that.getOperator().getIndex()));
        clone.setTargetOperand((Register)registerSet.get(that.getTargetOperand().getIndex()));
        return clone;
    }
}

