/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.program;

import com.github.chen0040.gp.commons.Indexable;
import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.lgp.enums.OperatorExecutionStatus;
import com.github.chen0040.gp.lgp.program.Register;
import java.io.Serializable;

public abstract class Operator
implements Serializable,
Indexable<Operator> {
    private static final long serialVersionUID = 4208195268877995533L;
    protected String symbol;
    protected boolean conditionalConstruct = false;
    protected int index;

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isConditionalConstruct() {
        return this.conditionalConstruct;
    }

    public Operator(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public abstract Operator makeCopy();

    public Operator copy(Operator rhs) {
        this.index = rhs.index;
        this.conditionalConstruct = rhs.conditionalConstruct;
        this.symbol = rhs.symbol;
        return this;
    }

    @Override
    public String getName() {
        return this.symbol;
    }

    public abstract OperatorExecutionStatus execute(Register var1, Register var2, Register var3, Observation var4);

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)o;
        if (this.conditionalConstruct != operator.conditionalConstruct) {
            return false;
        }
        if (this.index != operator.index) {
            return false;
        }
        return this.symbol != null ? this.symbol.equals(operator.symbol) : operator.symbol == null;
    }

    public int hashCode() {
        int result = this.symbol != null ? this.symbol.hashCode() : 0;
        result = 31 * result + (this.conditionalConstruct ? 1 : 0);
        result = 31 * result + this.index;
        return result;
    }
}

