/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.data.utils.StringUtils;
import com.github.chen0040.gp.commons.Indexable;
import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.exceptions.SizeMismatchedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Primitive
implements Serializable,
Indexable<Primitive> {
    private static final long serialVersionUID = -249257238928605728L;
    private final List<Double> inputs = new ArrayList<Double>();
    private final List<String> textInputs = new ArrayList<String>();
    private String textValue;
    private double value;
    private final String symbol;
    private final boolean readOnly;
    private int index;

    public Primitive() {
        this.symbol = "";
        this.readOnly = false;
    }

    public Primitive(int inputCount, String symbol, double value, String textValue, boolean readOnly) {
        int i;
        for (i = 0; i < inputCount; ++i) {
            this.inputs.add(0.0);
        }
        for (i = 0; i < inputCount; ++i) {
            this.textInputs.add(null);
        }
        this.symbol = symbol;
        this.value = value;
        this.textValue = textValue;
        this.readOnly = readOnly;
    }

    public boolean isTerminal() {
        return this.inputs.isEmpty();
    }

    @Override
    public String getName() {
        if (StringUtils.isEmpty((String)this.symbol)) {
            return (this.isReadOnly() ? "c" : "v") + this.index;
        }
        return this.symbol;
    }

    public Primitive copy(Primitive that) {
        if (!this.symbol.equals(that.getSymbol())) {
            throw new RuntimeException("Symbol not matched for copy to proceed");
        }
        this.inputs.clear();
        this.inputs.addAll(that.inputs);
        this.textInputs.clear();
        this.textInputs.addAll(that.textInputs);
        this.value = that.value;
        this.textValue = that.textValue;
        this.index = that.index;
        return this;
    }

    public int arity() {
        return this.inputs.size();
    }

    public void beforeExecute(List<Double> values, Observation observation) {
        if (this.inputs.size() != values.size()) {
            throw new SizeMismatchedException(this.inputs.size(), values.size());
        }
        for (int i = 0; i < values.size(); ++i) {
            this.inputs.set(i, values.get(i));
        }
    }

    public void beforeExecuteWithText(List<String> values, Observation observation) {
        if (this.textInputs.size() != values.size()) {
            throw new SizeMismatchedException(this.inputs.size(), values.size());
        }
        for (int i = 0; i < values.size(); ++i) {
            this.textInputs.set(i, values.get(i));
        }
    }

    public void setInput(int index, double value) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        this.inputs.set(index, value);
    }

    public void setInput(int index, String value) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        this.textInputs.set(index, value);
    }

    public double getInput(int index) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        return this.inputs.get(index);
    }

    public String getTextInput(int index) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        return this.textInputs.get(index);
    }

    public void setValue(double val) {
        if (this.readOnly) {
            throw new RuntimeException("The primitive is readonly");
        }
        this.value = val;
    }

    public void setValue(String val) {
        if (this.readOnly) {
            throw new RuntimeException("The primitive is readonly");
        }
        this.textValue = val;
    }

    public double getValue() {
        return this.value;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public abstract Primitive makeCopy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Primitive primitive = (Primitive)o;
        if (this.readOnly != primitive.readOnly) {
            return false;
        }
        if (this.index != primitive.index) {
            return false;
        }
        return this.symbol != null ? this.symbol.equals(primitive.symbol) : primitive.symbol == null;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.symbol != null ? this.symbol.hashCode() : 0);
        result = 31 * result + (this.readOnly ? 1 : 0);
        result = 31 * result + this.index;
        return result;
    }

    public abstract void execute(Observation var1);

    public void executeWithText(Observation observation) {
    }
}

