/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.data.utils.TupleTwo;
import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.enums.TGPInitializationStrategy;
import com.github.chen0040.gp.treegp.program.ConstantSet;
import com.github.chen0040.gp.treegp.program.OperatorSet;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.Terminal;
import com.github.chen0040.gp.treegp.program.TreeGenerator;
import com.github.chen0040.gp.treegp.program.TreeNode;
import com.github.chen0040.gp.treegp.program.VariableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Program
implements Serializable,
Comparable<Program> {
    private final OperatorSet operatorSet = new OperatorSet();
    private final VariableSet variableSet = new VariableSet();
    private final ConstantSet constantSet = new ConstantSet();
    private TreeNode root;
    private int depth;
    private int length;

    public OperatorSet getOperatorSet() {
        return this.operatorSet;
    }

    public VariableSet getVariableSet() {
        return this.variableSet;
    }

    public ConstantSet getConstantSet() {
        return this.constantSet;
    }

    public String mathExpression() {
        if (this.root == null) {
            return "";
        }
        return this.root.mathExpression();
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode node) {
        this.root = node;
    }

    public void copy(Program that) {
        this.operatorSet.copy(that.operatorSet);
        this.variableSet.copy(that.variableSet);
        this.constantSet.copy(that.constantSet);
        this.depth = that.depth;
        this.length = that.length;
        this.root = that.root != null ? that.root.makeCopy(this.operatorSet, this.variableSet, this.constantSet) : null;
    }

    public Program makeCopy() {
        Program clone = new Program();
        clone.copy(this);
        return clone;
    }

    public double execute(Observation observation) {
        return this.root.execute(observation);
    }

    public String executeWithText(Observation observation) {
        return this.root.executeWithText(observation);
    }

    public void read(Observation observation) {
        int inputCount = observation.inputCount();
        for (int i = 0; i < this.variableSet.size(); ++i) {
            int j = i % inputCount;
            this.variableSet.set(j, observation.getInput(j));
        }
    }

    public void readText(Observation observation) {
        int inputCount = observation.inputCount();
        for (int i = 0; i < this.variableSet.size(); ++i) {
            int j = i % inputCount;
            this.variableSet.set(j, observation.getTextInput(j));
        }
    }

    public Terminal anyTerminal(RandEngine randEngine) {
        int constant_count;
        int variable_count = this.variableSet.size();
        int r = randEngine.nextInt(variable_count + (constant_count = this.constantSet.size()));
        if (r < variable_count) {
            return (Terminal)this.variableSet.get(r);
        }
        return (Terminal)this.constantSet.get(r - variable_count);
    }

    public boolean isBetterThan(Program rhs) {
        return this.compareTo(rhs) < 0;
    }

    @Override
    public int compareTo(Program that) {
        int cmp = Integer.compare(this.depth, that.depth);
        if (cmp == 0) {
            return Integer.compare(this.length, that.length);
        }
        return cmp;
    }

    public void createWithDepth(int allowableDepth, TreeGP manager, TGPInitializationStrategy initializationStrategy) {
        int constantCount = manager.getConstants().size();
        for (int i = 0; i < constantCount; ++i) {
            this.constantSet.add(new Terminal("c" + i, manager.constant(i), manager.constantText(i), true), manager.constantWeight(i));
        }
        int registerCount = manager.getVariableCount();
        for (int i = 0; i < registerCount; ++i) {
            this.variableSet.add(new Terminal("v" + i, 0.0, "", false), 1.0);
        }
        int operatorCount = manager.getOperatorSet().size();
        for (int i = 0; i < operatorCount; ++i) {
            Primitive operator = (Primitive)manager.getOperatorSet().get(i);
            this.operatorSet.add(operator, manager.getOperatorSet().getWeight(i));
        }
        this.root = TreeGenerator.createWithDepth(this, allowableDepth, manager, initializationStrategy);
        this.calcLength();
        this.calcDepth();
    }

    public int calcLength() {
        this.length = this.root.length();
        return this.length;
    }

    public int calcDepth() {
        this.depth = this.root.depth();
        return this.depth;
    }

    public Primitive anyOperatorWithArityLessThan(int s, RandEngine randEngine) {
        return this.operatorSet.anyWithArityLessThan(s, randEngine);
    }

    public Primitive anyOperator(RandEngine randEngine) {
        return (Primitive)this.operatorSet.any(randEngine);
    }

    public Primitive anyPrimitive(RandEngine randEngine) {
        double r = randEngine.uniform();
        if (r < 0.3333) {
            return (Primitive)this.constantSet.any(randEngine);
        }
        if (r < 0.6666) {
            return (Primitive)this.variableSet.any(randEngine);
        }
        return this.anyOperator(randEngine);
    }

    public TupleTwo<TreeNode, TreeNode> anyNode(RandEngine randEngine) {
        return this.anyNode(false, randEngine);
    }

    public TupleTwo<TreeNode, TreeNode> anyNode(boolean bias, RandEngine randEngine) {
        List<TupleTwo<TreeNode, TreeNode>> nodes = this.flattenNodes();
        if (bias) {
            if (randEngine.uniform() <= 0.1) {
                ArrayList<TupleTwo<TreeNode, TreeNode>> terminal_nodes = new ArrayList<TupleTwo<TreeNode, TreeNode>>();
                for (TupleTwo<TreeNode, TreeNode> tuple : nodes) {
                    TreeNode node = (TreeNode)tuple._1();
                    if (!node.isTerminal()) continue;
                    terminal_nodes.add(tuple);
                }
                if (terminal_nodes.size() > 0) {
                    return (TupleTwo)terminal_nodes.get(randEngine.nextInt(terminal_nodes.size()));
                }
                return nodes.get(randEngine.nextInt(nodes.size()));
            }
            ArrayList<TupleTwo<TreeNode, TreeNode>> function_nodes = new ArrayList<TupleTwo<TreeNode, TreeNode>>();
            for (TupleTwo<TreeNode, TreeNode> tuple : nodes) {
                TreeNode node = (TreeNode)tuple._1();
                if (node.isTerminal()) continue;
                function_nodes.add(tuple);
            }
            if (function_nodes.size() > 0) {
                return (TupleTwo)function_nodes.get(randEngine.nextInt(function_nodes.size()));
            }
            return nodes.get(randEngine.nextInt(nodes.size()));
        }
        return nodes.get(randEngine.nextInt(nodes.size()));
    }

    public List<TupleTwo<TreeNode, TreeNode>> flattenNodes() {
        ArrayList<TupleTwo<TreeNode, TreeNode>> list = new ArrayList<TupleTwo<TreeNode, TreeNode>>();
        this.collectNodes(this.root, null, list);
        return list;
    }

    private void collectNodes(TreeNode node, TreeNode parent_node, List<TupleTwo<TreeNode, TreeNode>> list) {
        if (node == null) {
            return;
        }
        if (parent_node != null) assert (parent_node.getChildren().contains(node));
        list.add((TupleTwo<TreeNode, TreeNode>)new TupleTwo((Object)node, (Object)parent_node));
        for (TreeNode child : node.getChildren()) {
            this.collectNodes(child, node, list);
        }
    }

    public Primitive matchPrimitive(Primitive that) {
        int index = that.getIndex();
        if (that.isTerminal()) {
            if (that.isReadOnly()) {
                return (Primitive)this.constantSet.get(index);
            }
            return (Primitive)this.variableSet.get(index);
        }
        return (Primitive)this.operatorSet.get(index);
    }

    public int getDepth() {
        return this.depth;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return this.root.toString();
    }
}

