/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.enums.TGPInitializationStrategy;
import com.github.chen0040.gp.treegp.program.OperatorSet;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.Program;
import com.github.chen0040.gp.treegp.program.TreeNode;

public class TreeGenerator {
    public static void createWithDepth(Program program, TreeNode x, int allowableDepth, TGPInitializationStrategy method, RandEngine randEngine) {
        int child_count = x.arity();
        for (int i = 0; i != child_count; ++i) {
            Primitive primitive = TreeGenerator.anyPrimitive(program, allowableDepth, method, randEngine);
            TreeNode child = new TreeNode(primitive);
            x.getChildren().add(child);
            if (primitive.isTerminal()) continue;
            TreeGenerator.createWithDepth(program, child, allowableDepth - 1, method, randEngine);
        }
    }

    public static TreeNode createWithDepth(Program program, int allowableDepth, TreeGP manager, TGPInitializationStrategy method) {
        TreeNode root;
        OperatorSet operatorSet = program.getOperatorSet();
        RandEngine randEngine = manager.getRandEngine();
        if (method == TGPInitializationStrategy.INITIALIZATION_METHOD_RANDOM_BRANCH) {
            int s = allowableDepth;
            Primitive non_terminal = program.anyOperatorWithArityLessThan(s, randEngine);
            if (non_terminal == null) {
                root = new TreeNode(program.anyTerminal(randEngine));
            } else {
                root = new TreeNode(non_terminal);
                int b_n = non_terminal.arity();
                s = (int)Math.floor((double)s / (double)b_n);
                TreeGenerator.randomBranch(program, root, s, randEngine);
            }
        } else if (method == TGPInitializationStrategy.INITIALIZATION_METHOD_PTC1) {
            int expectedTreeSize = 20;
            int b_n_sum = 0;
            for (int i = 0; i < operatorSet.size(); ++i) {
                b_n_sum += ((Primitive)operatorSet.get(i)).arity();
            }
            double p = (1.0 - 1.0 / (double)expectedTreeSize) / ((double)b_n_sum / (double)operatorSet.size());
            Primitive data = null;
            data = randEngine.uniform() <= p ? program.anyOperator(randEngine) : program.anyTerminal(randEngine);
            root = new TreeNode(data);
            TreeGenerator.PTC1(program, root, p, allowableDepth - 1, randEngine);
        } else {
            root = new TreeNode(TreeGenerator.anyPrimitive(program, allowableDepth, method, randEngine));
            TreeGenerator.createWithDepth(program, root, allowableDepth - 1, method, randEngine);
        }
        return root;
    }

    private static void randomBranch(Program program, TreeNode x, int s, RandEngine randEngine) {
        int child_count = x.arity();
        for (int i = 0; i != child_count; ++i) {
            TreeNode child;
            Primitive non_terminal = program.anyOperatorWithArityLessThan(s, randEngine);
            if (non_terminal == null) {
                child = new TreeNode(program.anyTerminal(randEngine));
                x.getChildren().add(child);
                continue;
            }
            child = new TreeNode(non_terminal);
            x.getChildren().add(child);
            int b_n = non_terminal.arity();
            int s_pi = (int)Math.floor((double)s / (double)b_n);
            TreeGenerator.randomBranch(program, child, s_pi, randEngine);
        }
    }

    private static void PTC1(Program program, TreeNode parent_node, double p, int allowableDepth, RandEngine randEngine) {
        int child_count = parent_node.arity();
        for (int i = 0; i != child_count; ++i) {
            Primitive data = allowableDepth == 0 ? program.anyTerminal(randEngine) : (randEngine.uniform() <= p ? program.anyOperator(randEngine) : program.anyTerminal(randEngine));
            TreeNode child = new TreeNode(data);
            parent_node.getChildren().add(child);
            if (data.isTerminal()) continue;
            TreeGenerator.PTC1(program, child, p, allowableDepth - 1, randEngine);
        }
    }

    public static Primitive anyPrimitive(Program program, int allowableDepth, TGPInitializationStrategy method, RandEngine randEngine) {
        int terminal_count = program.getVariableSet().size() + program.getConstantSet().size();
        int function_count = program.getOperatorSet().size();
        double terminal_prob = (double)terminal_count / (double)(terminal_count + function_count);
        if (allowableDepth <= 0 || method == TGPInitializationStrategy.INITIALIZATION_METHOD_GROW && randEngine.uniform() <= terminal_prob) {
            return program.anyTerminal(randEngine);
        }
        return program.anyOperator(randEngine);
    }
}

