/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.program;

import com.github.chen0040.gp.lgp.program.Indexable;
import com.github.chen0040.gp.services.RandEngine;
import java.util.ArrayList;
import java.util.List;

public class EntityContainer<T extends Indexable<T>> {
    protected final List<T> entities = new ArrayList<T>();
    protected final List<Double> weights = new ArrayList<Double>();

    public double weightSum() {
        if (this.weights.isEmpty()) {
            return 0.0;
        }
        return (Double)this.weights.stream().reduce((a, b) -> a + b).get();
    }

    public T anyOther(T excluded, RandEngine rand) {
        double weightSum = this.weightSum();
        block0: for (int attempts = 0; attempts < 10; ++attempts) {
            double r = weightSum * rand.uniform();
            double accSum = 0.0;
            for (int i = 0; i < this.entities.size(); ++i) {
                if (!(r <= (accSum += this.weights.get(i).doubleValue()))) continue;
                if (this.entities.get(i) == excluded) continue block0;
                return (T)((Indexable)this.entities.get(i));
            }
        }
        return excluded;
    }

    public T get(int index) {
        return (T)((Indexable)this.entities.get(index));
    }

    public int size() {
        return this.entities.size();
    }

    public void add(T entity, double weight) {
        entity.setIndex(this.entities.size());
        this.entities.add(entity);
        this.weights.add(weight);
    }

    public void add(T entity) {
        this.add(entity, 1.0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entities.size(); ++i) {
            if (i != 0) {
                sb.append("\r\n");
            }
            sb.append("entity[").append(i).append("]: ").append(this.entities.get(i));
        }
        return sb.toString();
    }

    public void copy(EntityContainer<T> that) {
        for (int i = 0; i < that.entities.size(); ++i) {
            this.entities.add(((Indexable)that.entities.get(i)).makeCopy());
            this.weights.add(that.weights.get(i));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EntityContainer)) {
            return false;
        }
        EntityContainer that = (EntityContainer)o;
        if (this.entities.size() != that.entities.size()) {
            return false;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            if (((Indexable)this.entities.get(i)).equals(that.entities.get(i))) continue;
            return false;
        }
        return this.weights.equals(that.weights);
    }

    public int hashCode() {
        int result = this.entities.hashCode();
        result = 31 * result + this.weights.hashCode();
        return result;
    }

    public T any(RandEngine randEngine) {
        return this.anyOther(null, randEngine);
    }

    public double getWeight(int index) {
        return this.weights.get(index);
    }

    public void addAll(T ... entities) {
        for (int i = 0; i < entities.length; ++i) {
            this.add(entities[i]);
        }
    }
}

