/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.program;

import com.github.chen0040.gp.lgp.program.Indexable;
import com.github.chen0040.gp.services.RandEngine;
import java.io.Serializable;

public class Register
implements Serializable,
Indexable<Register> {
    private static final long serialVersionUID = 8423690373685553734L;
    private boolean constant;
    private double value;
    private int index;

    @Override
    public Register makeCopy() {
        Register clone = new Register();
        clone.setConstant(this.constant);
        clone.setValue(this.value);
        clone.setIndex(this.index);
        return clone;
    }

    public void mutate(RandEngine randomEngine, double sd) {
        this.value += randomEngine.normal(0.0, 1.0) * sd;
    }

    public String toString() {
        return (this.constant ? "c" : "r") + "[" + this.index + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Register register = (Register)o;
        if (this.constant != register.constant) {
            return false;
        }
        if (Double.compare(register.value, this.value) != 0) {
            return false;
        }
        return this.index == register.index;
    }

    public int hashCode() {
        int result = this.constant ? 1 : 0;
        long temp = Double.doubleToLongBits(this.value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.index;
        return result;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }
}

