/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.helpers.InstructionHelper;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.services.RandEngine;
import java.util.List;

public class MicroMutation {
    private static void mutateInstructionConstant(Program program, LGP manager, RandEngine randEngine) {
        Instruction selected_instruction = null;
        for (Instruction instruction : program.getInstructions()) {
            if (instruction.isStructuralIntron() || !instruction.getOperand1().isConstant() && !instruction.getOperand2().isConstant()) continue;
            if (selected_instruction == null) {
                selected_instruction = instruction;
                continue;
            }
            if (!(randEngine.uniform() < 0.5)) continue;
            selected_instruction = instruction;
        }
        if (selected_instruction != null) {
            InstructionHelper.mutateConstant(selected_instruction, randEngine, manager.getMicroMutateConstantStandardDeviation());
        }
    }

    private static void mutateInstructionRegister(Program program, RandEngine randEngine) {
        List<Instruction> instructions = program.getInstructions();
        int instructionCount = instructions.size();
        Instruction selected_instruction = instructions.get(randEngine.nextInt(instructionCount));
        double p_const = 0.0;
        for (Instruction instruction : instructions) {
            if (!instruction.getOperand1().isConstant() && !instruction.getOperand2().isConstant()) continue;
            p_const += 1.0;
        }
        InstructionHelper.mutateRegister(program, selected_instruction, randEngine, p_const /= (double)instructionCount);
    }

    private static void mutateInstructionOperator(Program program, RandEngine randEngine) {
        List<Instruction> instructions = program.getInstructions();
        int instructionCount = instructions.size();
        Instruction instruction = instructions.get(randEngine.nextInt(instructionCount));
        InstructionHelper.mutateOperator(program, instruction, randEngine);
    }

    public static void mutate(Program program, LGP manager, RandEngine randEngine) {
        double micro_mutate_operator_rate = manager.getMicroMutateOperatorRate();
        double micro_mutate_register_rate = manager.getMicroMutateRegisterRate();
        double micro_mutate_constant_rate = manager.getMicroMutateConstantRate();
        double sum = micro_mutate_constant_rate + micro_mutate_operator_rate + micro_mutate_register_rate;
        double operator_sector = micro_mutate_operator_rate /= sum;
        double register_sector = operator_sector + (micro_mutate_register_rate /= sum);
        double r = randEngine.uniform();
        if (r < operator_sector) {
            MicroMutation.mutateInstructionOperator(program, randEngine);
        } else if (r < register_sector) {
            MicroMutation.mutateInstructionRegister(program, randEngine);
        } else {
            MicroMutation.mutateInstructionConstant(program, manager, randEngine);
        }
        program.invalidateCost();
    }
}

