/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.gp.Crossover;
import com.github.chen0040.gp.lgp.gp.MacroMutation;
import com.github.chen0040.gp.lgp.gp.MicroMutation;
import com.github.chen0040.gp.lgp.gp.PopulationInitialization;
import com.github.chen0040.gp.lgp.gp.Replacement;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.utils.CollectionUtils;
import com.github.chen0040.gp.utils.TournamentSelection;
import com.github.chen0040.gp.utils.TournamentSelectionResult;
import com.github.chen0040.gp.utils.TupleTwo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Population {
    private Optional<Program> globalBestProgram = Optional.empty();
    private List<Program> programs = new ArrayList<Program>();
    private int currentGeneration = 0;
    private final LGP manager;
    private final RandEngine randEngine;
    private Program bestProgramInCurrentGeneration = null;

    public Population(LGP manager, RandEngine randEngine) {
        this.manager = manager;
        this.randEngine = randEngine;
    }

    protected void evaluate(LGP manager) {
        double bestCost = Double.MAX_VALUE;
        for (int i = 0; i < this.programs.size(); ++i) {
            Program p = this.programs.get(i);
            double cost = manager.evaluateCost(p);
            p.setCost(cost);
            p.setCostValid(true);
            if (!(p.getCost() < bestCost)) continue;
            this.bestProgramInCurrentGeneration = p;
            bestCost = p.getCost();
        }
        this.updateGlobal(this.bestProgramInCurrentGeneration);
    }

    public void initialize() {
        PopulationInitialization.initialize(this.programs, this.manager, this.randEngine);
        this.evaluate(this.manager);
    }

    private void updateGlobal(Program lgp) {
        if (!this.globalBestProgram.isPresent() || CollectionUtils.isBetterThan(lgp, (Comparable)this.globalBestProgram.get())) {
            this.globalBestProgram = Optional.of(lgp.makeEffectiveCopy());
        }
    }

    public boolean isTerminated() {
        return this.currentGeneration >= this.manager.getMaxGeneration();
    }

    public void evolve() {
        int iPopSize = this.manager.getPopulationSize();
        int program_count = 0;
        int computationBudget = iPopSize * 8;
        for (int counter = 0; program_count < iPopSize && counter < computationBudget; ++counter) {
            TournamentSelectionResult<Program> tournament = TournamentSelection.select(this.programs, this.randEngine);
            TupleTwo<Program, Program> tournament_winners = tournament.getWinners();
            TupleTwo<Program, Program> tournament_losers = tournament.getLosers();
            Program tp1 = tournament_winners._1().makeCopy();
            Program tp2 = tournament_winners._2().makeCopy();
            double r = this.randEngine.uniform();
            if (r < this.manager.getCrossoverRate()) {
                Crossover.apply(tp1, tp2, this.manager, this.randEngine);
            }
            if ((r = this.randEngine.uniform()) < this.manager.getMacroMutationRate()) {
                MacroMutation.mutate(tp1, this.manager, this.randEngine);
            }
            if ((r = this.randEngine.uniform()) < this.manager.getMacroMutationRate()) {
                MacroMutation.mutate(tp2, this.manager, this.randEngine);
            }
            if ((r = this.randEngine.uniform()) < this.manager.getMicroMutationRate()) {
                MicroMutation.mutate(tp1, this.manager, this.randEngine);
            }
            if ((r = this.randEngine.uniform()) < this.manager.getMicroMutationRate()) {
                MicroMutation.mutate(tp2, this.manager, this.randEngine);
            }
            tp1.setCost(this.manager.evaluateCost(tp1));
            tp1.setCostValid(true);
            tp2.setCost(this.manager.evaluateCost(tp2));
            tp2.setCostValid(true);
            Program loser1 = Replacement.compete(this.programs, tournament_losers._1(), tp1, this.manager, this.randEngine);
            Program loser2 = Replacement.compete(this.programs, tournament_losers._2(), tp2, this.manager, this.randEngine);
            if (loser1 == tournament_losers._1()) {
                ++program_count;
            }
            if (loser2 != tournament_losers._2()) continue;
            ++program_count;
        }
        double bestCost = Double.MAX_VALUE;
        for (int i = 0; i < this.programs.size(); ++i) {
            Program p = this.programs.get(i);
            if (!(p.getCost() < bestCost)) continue;
            this.bestProgramInCurrentGeneration = p;
            bestCost = p.getCost();
        }
        this.updateGlobal(this.bestProgramInCurrentGeneration);
        ++this.currentGeneration;
    }

    public Program getGlobalBestProgram() {
        return this.globalBestProgram.get();
    }

    public double getCostInCurrentGeneration() {
        return this.bestProgramInCurrentGeneration.getCost();
    }

    public List<Program> getPrograms() {
        return this.programs;
    }

    public int getCurrentGeneration() {
        return this.currentGeneration;
    }

    public LGP getManager() {
        return this.manager;
    }

    public RandEngine getRandEngine() {
        return this.randEngine;
    }

    public Program getBestProgramInCurrentGeneration() {
        return this.bestProgramInCurrentGeneration;
    }

    public void setPrograms(List<Program> programs) {
        this.programs = programs;
    }

    public void setCurrentGeneration(int currentGeneration) {
        this.currentGeneration = currentGeneration;
    }

    public void setBestProgramInCurrentGeneration(Program bestProgramInCurrentGeneration) {
        this.bestProgramInCurrentGeneration = bestProgramInCurrentGeneration;
    }
}

