/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.program;

import com.github.chen0040.gp.lgp.enums.OperatorExecutionStatus;
import com.github.chen0040.gp.lgp.program.Operator;
import com.github.chen0040.gp.lgp.program.Register;
import java.io.Serializable;

public class Instruction
implements Serializable {
    private static final long serialVersionUID = -2555357716504360141L;
    private Operator operator;
    private Register operand1;
    private Register operand2;
    private Register targetOperand;
    private boolean structuralIntron = false;

    public OperatorExecutionStatus execute() {
        return this.operator.execute(this.operand1, this.operand2, this.targetOperand);
    }

    public Instruction makeCopy() {
        Instruction clone = new Instruction();
        clone.structuralIntron = this.structuralIntron;
        clone.operator = this.operator;
        clone.operand1 = this.operand1;
        clone.operand2 = this.operand2;
        clone.targetOperand = this.targetOperand;
        return clone;
    }

    public String toString() {
        return "<".concat(this.operator.toString()).concat("\t").concat(this.operand1.toString()).concat("\t").concat(this.operand2.toString()).concat("\t").concat(this.targetOperand.toString()).concat(">").concat(this.structuralIntron ? "(intron)" : "");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Register getOperand1() {
        return this.operand1;
    }

    public Register getOperand2() {
        return this.operand2;
    }

    public Register getTargetOperand() {
        return this.targetOperand;
    }

    public boolean isStructuralIntron() {
        return this.structuralIntron;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public void setOperand1(Register operand1) {
        this.operand1 = operand1;
    }

    public void setOperand2(Register operand2) {
        this.operand2 = operand2;
    }

    public void setTargetOperand(Register targetOperand) {
        this.targetOperand = targetOperand;
    }

    public void setStructuralIntron(boolean structuralIntron) {
        this.structuralIntron = structuralIntron;
    }
}

