/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.program;

import com.github.chen0040.gp.exceptions.InvalidCostException;
import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.enums.OperatorExecutionStatus;
import com.github.chen0040.gp.lgp.gp.BasicObservation;
import com.github.chen0040.gp.lgp.gp.Observation;
import com.github.chen0040.gp.lgp.helpers.InstructionHelper;
import com.github.chen0040.gp.lgp.program.ConstantSet;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.OperatorSet;
import com.github.chen0040.gp.lgp.program.Register;
import com.github.chen0040.gp.lgp.program.RegisterSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Program
implements Serializable,
Comparable<Program> {
    private static final long serialVersionUID = -9169643464218638898L;
    private RegisterSet registerSet = new RegisterSet();
    private ConstantSet constantSet = new ConstantSet();
    private OperatorSet operatorSet = new OperatorSet();
    private List<Instruction> instructions = new ArrayList<Instruction>();
    private double cost;
    private boolean costValid;

    public void markStructuralIntrons(LGP manager) {
        int instruction_count = this.instructions.size();
        for (int i = instruction_count - 1; i >= 0; --i) {
            this.instructions.get(i).setStructuralIntron(true);
        }
        HashSet<Integer> Reff = new HashSet<Integer>();
        int io_register_count = manager.getRegisterCount();
        for (int i = 0; i < io_register_count; ++i) {
            Reff.add(i);
        }
        Instruction current_instruction = null;
        Instruction prev_instruction = null;
        for (int i = instruction_count - 1; i >= 0; --i) {
            prev_instruction = current_instruction;
            current_instruction = this.instructions.get(i);
            if (current_instruction.getOperator().isConditionalConstruct() && prev_instruction != null) {
                if (prev_instruction.isStructuralIntron()) continue;
                current_instruction.setStructuralIntron(false);
                continue;
            }
            if (!Reff.contains(current_instruction.getTargetOperand().getIndex())) continue;
            current_instruction.setStructuralIntron(false);
            Reff.remove(current_instruction.getTargetOperand().getIndex());
            if (!current_instruction.getOperand1().isConstant()) {
                Reff.add(current_instruction.getOperand1().getIndex());
            }
            if (current_instruction.getOperand2().isConstant()) continue;
            Reff.add(current_instruction.getOperand2().getIndex());
        }
    }

    public void MarkStructuralIntrons(int stop_point, Set<Integer> Reff, LGP manager) {
        int instruction_count = this.instructions.size();
        for (int i = instruction_count - 1; i > stop_point; --i) {
            this.instructions.get(i).setStructuralIntron(true);
        }
        Reff.clear();
        int register_count = manager.getRegisterCount();
        for (int i = 0; i < register_count; ++i) {
            Reff.add(i);
        }
        Instruction current_instruction = null;
        Instruction prev_instruction = null;
        for (int i = instruction_count - 1; i > stop_point; --i) {
            prev_instruction = current_instruction;
            current_instruction = this.instructions.get(i);
            if (current_instruction.getOperator().isConditionalConstruct() && prev_instruction != null) {
                if (prev_instruction.isStructuralIntron()) continue;
                current_instruction.setStructuralIntron(false);
                continue;
            }
            if (!Reff.contains(current_instruction.getTargetOperand().getIndex())) continue;
            current_instruction.setStructuralIntron(false);
            Reff.remove(current_instruction.getTargetOperand().getIndex());
            if (!current_instruction.getOperand1().isConstant()) {
                Reff.add(current_instruction.getOperand1().getIndex());
            }
            if (current_instruction.getOperand2().isConstant()) continue;
            Reff.add(current_instruction.getOperand2().getIndex());
        }
    }

    public void execute(Observation fitness_case) {
        int inputRegisterCount = this.registerSet.size();
        for (int i = 0; i < inputRegisterCount; ++i) {
            ((Register)this.registerSet.get(i)).setValue(fitness_case.getInput(i % fitness_case.inputCount()));
        }
        OperatorExecutionStatus command = OperatorExecutionStatus.LGP_EXECUTE_NEXT_INSTRUCTION;
        Instruction current_effective_instruction = null;
        Instruction prev_effective_instruction = null;
        for (Instruction instruction : this.instructions) {
            if (instruction.isStructuralIntron()) continue;
            prev_effective_instruction = current_effective_instruction;
            current_effective_instruction = instruction;
            if (command == OperatorExecutionStatus.LGP_EXECUTE_NEXT_INSTRUCTION) {
                command = current_effective_instruction.execute();
                continue;
            }
            if (!prev_effective_instruction.getOperator().isConditionalConstruct()) continue;
            command = OperatorExecutionStatus.LGP_EXECUTE_NEXT_INSTRUCTION;
        }
        int outputRegisterCount = Math.min(this.registerSet.size(), fitness_case.outputCount());
        for (int i = 0; i < outputRegisterCount; ++i) {
            fitness_case.setPredictedOutput(i, ((Register)this.registerSet.get(i)).getValue());
        }
    }

    public double[] execute(double[] input) {
        BasicObservation fitnessCase = new BasicObservation(input.length, input.length);
        this.execute(fitnessCase);
        double[] output = new double[input.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = fitnessCase.getOutput(i);
        }
        return output;
    }

    public Program makeCopy() {
        Program clone = new Program();
        clone.copy(this, false);
        return clone;
    }

    public void copy(Program that, boolean effectiveOnly) {
        this.registerSet.copy(that.registerSet);
        this.constantSet.copy(that.constantSet);
        this.operatorSet.copy(that.operatorSet);
        this.instructions.clear();
        for (int i = 0; i < that.instructions.size(); ++i) {
            if (effectiveOnly && !that.instructions.get(i).isStructuralIntron()) continue;
            this.instructions.add(InstructionHelper.makeCopy(that.instructions.get(i), this.registerSet, this.constantSet, this.operatorSet));
        }
        this.cost = that.cost;
        this.costValid = that.costValid;
    }

    public long effectiveInstructionCount() {
        return this.instructions.stream().filter(instruction -> !instruction.isStructuralIntron()).count();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("constants:");
        sb.append("\n").append(this.constantSet);
        sb.append("\nregisters:");
        sb.append("\n").append(this.registerSet);
        sb.append("\noperators:");
        sb.append("\n").append(this.operatorSet);
        for (int i = 0; i < this.instructions.size(); ++i) {
            sb.append("instruction[").append(i).append("]: ").append(this.instructions.get(i)).append("\n");
        }
        if (this.costValid) {
            sb.append("fitness: ").append(this.cost);
        } else {
            sb.append("Invalid Fitness");
        }
        return sb.toString();
    }

    public void invalidateCost() {
        this.costValid = false;
    }

    @Override
    public int compareTo(Program o) {
        if (!this.costValid || !o.costValid) {
            throw new InvalidCostException("cost of the programs involved in the comparison is not valid for comparison");
        }
        return Double.compare(this.cost, o.cost);
    }

    public int length() {
        return this.instructions.size();
    }

    public Program makeEffectiveCopy() {
        Program clone = new Program();
        clone.copy(this, true);
        return clone;
    }

    public RegisterSet getRegisterSet() {
        return this.registerSet;
    }

    public ConstantSet getConstantSet() {
        return this.constantSet;
    }

    public OperatorSet getOperatorSet() {
        return this.operatorSet;
    }

    public List<Instruction> getInstructions() {
        return this.instructions;
    }

    public double getCost() {
        return this.cost;
    }

    public boolean isCostValid() {
        return this.costValid;
    }

    public void setRegisterSet(RegisterSet registerSet) {
        this.registerSet = registerSet;
    }

    public void setConstantSet(ConstantSet constantSet) {
        this.constantSet = constantSet;
    }

    public void setOperatorSet(OperatorSet operatorSet) {
        this.operatorSet = operatorSet;
    }

    public void setInstructions(List<Instruction> instructions) {
        this.instructions = instructions;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setCostValid(boolean costValid) {
        this.costValid = costValid;
    }
}

