/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.utils;

import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.utils.CollectionUtils;
import com.github.chen0040.gp.utils.TournamentSelectionResult;
import com.github.chen0040.gp.utils.TupleTwo;
import java.util.List;
import org.apache.commons.math3.exception.OutOfRangeException;

public class TournamentSelection {
    public static <T extends Comparable<T>> TournamentSelectionResult<T> select(List<T> population, RandEngine randEngine) {
        Comparable bad2;
        Comparable good2;
        Comparable bad1;
        Comparable good1;
        if (population.size() < 4) {
            throw new OutOfRangeException((Number)population.size(), (Number)4, (Number)10000000);
        }
        CollectionUtils.shuffle(population, randEngine);
        if (CollectionUtils.isBetterThan((Comparable)population.get(0), (Comparable)population.get(1))) {
            good1 = (Comparable)population.get(0);
            bad1 = (Comparable)population.get(1);
        } else {
            good1 = (Comparable)population.get(1);
            bad1 = (Comparable)population.get(0);
        }
        if (CollectionUtils.isBetterThan((Comparable)population.get(2), (Comparable)population.get(3))) {
            good2 = (Comparable)population.get(2);
            bad2 = (Comparable)population.get(3);
        } else {
            good2 = (Comparable)population.get(3);
            bad2 = (Comparable)population.get(2);
        }
        TournamentSelectionResult<Comparable> result = new TournamentSelectionResult<Comparable>();
        result.setWinners(new TupleTwo<Comparable, Comparable>(good1, good2));
        result.setLosers(new TupleTwo<Comparable, Comparable>(bad1, bad2));
        return result;
    }
}

