/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.lgp.gp;

import com.github.chen0040.data.exceptions.NotImplementedException;
import com.github.chen0040.gp.lgp.LGP;
import com.github.chen0040.gp.lgp.enums.LGPCrossoverStrategy;
import com.github.chen0040.gp.lgp.helpers.InstructionHelper;
import com.github.chen0040.gp.lgp.program.Instruction;
import com.github.chen0040.gp.lgp.program.Program;
import com.github.chen0040.gp.services.RandEngine;
import java.util.ArrayList;
import java.util.List;

public class Crossover {
    public static void apply(Program program1, Program program2, LGP manager, RandEngine randEngine) {
        LGPCrossoverStrategy crossoverType = manager.getCrossoverStrategy();
        switch (crossoverType) {
            case Linear: {
                Crossover.linearCrossover(program1, program2, manager, randEngine);
                break;
            }
            case OnePoint: {
                Crossover.onePointCrossover(program1, program2, manager, randEngine);
                break;
            }
            case OneSegment: {
                Crossover.oneSegmentCrossover(program1, program2, manager, randEngine);
                break;
            }
            default: {
                throw new NotImplementedException();
            }
        }
    }

    private static void oneSegmentCrossover(Program gp1, Program gp2, LGP manager, RandEngine randEngine) {
        double prob_r = randEngine.uniform();
        if (gp1.length() < manager.getMaxProgramLength() && (prob_r <= manager.getInsertionProbability() || gp1.length() == manager.getMinProgramLength())) {
            int i1 = randEngine.nextInt(gp1.length());
            int max_segment_length = gp2.length() < manager.getMaxSegmentLength() ? gp2.length() : manager.getMaxSegmentLength();
            int ls2 = 1 + randEngine.nextInt(max_segment_length);
            if (gp1.length() + ls2 > manager.getMaxProgramLength()) {
                ls2 = manager.getMaxProgramLength() - gp2.length() + 1;
            }
            if (ls2 == gp2.length()) {
                ls2 = gp2.length() - 1;
            }
            int i2 = randEngine.nextInt(gp2.length() - ls2);
            List<Instruction> instructions1 = gp1.getInstructions();
            List<Instruction> instructions2 = gp2.getInstructions();
            ArrayList<Instruction> s = new ArrayList<Instruction>();
            for (int i = i2; i != i2 + ls2; ++i) {
                Instruction instruction = instructions2.get(i);
                Instruction instruction_cloned = instruction.makeCopy();
                s.add(InstructionHelper.reassign2Program(instruction_cloned, gp1));
            }
            instructions1.addAll(i1, s);
        }
        if (gp1.length() > manager.getMinProgramLength() && (prob_r > manager.getInsertionProbability() || gp1.length() == manager.getMaxProgramLength())) {
            int max_segment_length = gp2.length() < manager.getMaxSegmentLength() ? gp2.length() : manager.getMaxSegmentLength();
            int ls1 = 1 + randEngine.nextInt(max_segment_length);
            if (gp1.length() < ls1) {
                ls1 = gp1.length() - manager.getMinProgramLength();
            } else if (gp1.length() - ls1 < manager.getMinProgramLength()) {
                ls1 = gp1.length() - manager.getMinProgramLength();
            }
            int i1 = randEngine.nextInt(gp1.length() - ls1);
            List<Instruction> instructions1 = gp1.getInstructions();
            for (int j = ls1 - 1; j >= i1; --j) {
                instructions1.remove(j);
            }
        }
        gp1.invalidateCost();
    }

    private static void onePointCrossover(Program gp1, Program gp2, LGP manager, RandEngine randEngine) {
        int i;
        if (gp1.length() > gp2.length()) {
            gp2 = gp1 = gp2;
        }
        int max_distance_of_crossover_points = gp1.length() - 1 < manager.getMaxDistanceOfCrossoverPoints() ? manager.getMaxDistanceOfCrossoverPoints() : gp1.length() - 1;
        int i1 = randEngine.nextInt(gp1.length());
        int i2 = randEngine.nextInt(gp2.length());
        int crossover_point_distance = i1 > i2 ? i1 - i2 : i2 - i1;
        int ls1 = gp1.length() - i1;
        int ls2 = gp2.length() - i2;
        boolean not_feasible = true;
        for (int count = 0; not_feasible && count < 10; ++count) {
            not_feasible = false;
            if (crossover_point_distance > max_distance_of_crossover_points) {
                not_feasible = true;
                i1 = randEngine.nextInt(gp1.length());
                crossover_point_distance = i1 > (i2 = randEngine.nextInt(gp2.length())) ? i1 - i2 : i2 - i1;
                continue;
            }
            ls1 = gp1.length() - i1;
            if (ls1 > (ls2 = gp2.length() - i2)) {
                not_feasible = true;
                i1 = randEngine.nextInt(gp1.length());
                crossover_point_distance = i1 > (i2 = randEngine.nextInt(gp2.length())) ? i1 - i2 : i2 - i1;
                continue;
            }
            if (gp2.length() - (ls2 - ls1) < manager.getMinProgramLength() || gp1.length() + (ls2 - ls1) > manager.getMaxProgramLength()) {
                not_feasible = true;
                if (gp1.length() >= gp2.length()) {
                    i1 = i2;
                } else {
                    i2 = i1;
                }
                crossover_point_distance = 0;
                continue;
            }
            not_feasible = false;
        }
        List<Instruction> instructions1 = gp1.getInstructions();
        List<Instruction> instructions2 = gp2.getInstructions();
        ArrayList<Instruction> instructions1_1 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions1_2 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions2_1 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions2_2 = new ArrayList<Instruction>();
        for (i = 0; i < i1; ++i) {
            instructions1_1.add(instructions1.get(i));
        }
        for (i = i1; i < instructions1.size(); ++i) {
            instructions1_2.add(instructions1.get(i));
        }
        for (i = 0; i < i2; ++i) {
            instructions2_1.add(instructions2.get(i));
        }
        for (i = i2; i < instructions2.size(); ++i) {
            instructions2_2.add(instructions2.get(i));
        }
        instructions1.clear();
        instructions2.clear();
        for (i = 0; i < i1; ++i) {
            instructions1.add((Instruction)instructions1_1.get(i));
        }
        for (i = 0; i < instructions2_2.size(); ++i) {
            instructions1.add(InstructionHelper.reassign2Program((Instruction)instructions2_2.get(i), gp1));
        }
        for (i = 0; i < i2; ++i) {
            instructions2.add((Instruction)instructions2_1.get(i));
        }
        for (i = 0; i < instructions1_2.size(); ++i) {
            instructions2.add(InstructionHelper.reassign2Program((Instruction)instructions1_2.get(i), gp2));
        }
        gp1.invalidateCost();
        gp2.invalidateCost();
    }

    private static void linearCrossover(Program gp1, Program gp2, LGP manager, RandEngine randEngine) {
        int i;
        int lsd;
        int max_crossover_point_distance;
        int i2;
        int i1;
        if (gp1.length() > gp2.length()) {
            gp2 = gp1 = gp2;
        }
        int cross_point_distance = (i1 = randEngine.nextInt(gp1.length())) > (i2 = randEngine.nextInt(gp2.length())) ? i1 - i2 : i2 - i1;
        int n = max_crossover_point_distance = gp1.length() - 1 > manager.getMaxDistanceOfCrossoverPoints() ? manager.getMaxDistanceOfCrossoverPoints() : gp1.length() - 1;
        while (cross_point_distance > max_crossover_point_distance) {
            i1 = randEngine.nextInt(gp1.length());
            cross_point_distance = i1 > (i2 = randEngine.nextInt(gp2.length())) ? i1 - i2 : i2 - i1;
        }
        int s1_max = gp1.length() - i1 > manager.getMaxDifferenceOfSegmentLength() ? manager.getMaxDifferenceOfSegmentLength() : gp1.length() - i1;
        int s2_max = gp2.length() - i2 > manager.getMaxDifferenceOfSegmentLength() ? manager.getMaxDifferenceOfSegmentLength() : gp2.length() - i2;
        int ls1 = 1 + randEngine.nextInt(s1_max);
        int ls2 = 1 + randEngine.nextInt(s2_max);
        int n2 = lsd = ls1 > ls2 ? ls1 - ls2 : ls2 - ls1;
        while (ls1 > ls2 && lsd > manager.getMaxDifferenceOfSegmentLength()) {
            ls1 = 1 + randEngine.nextInt(s1_max);
            lsd = ls1 > (ls2 = 1 + randEngine.nextInt(s2_max)) ? ls1 - ls2 : ls2 - ls1;
        }
        if (gp2.length() - (ls2 - ls1) < manager.getMinProgramLength() || gp1.length() + (ls2 - ls1) > manager.getMaxProgramLength()) {
            if (randEngine.uniform() < 0.5) {
                ls2 = ls1;
            } else {
                ls1 = ls2;
            }
            if (i1 + ls1 > gp1.length()) {
                ls1 = gp1.length() - i1;
            }
            if (i2 + ls2 > gp2.length()) {
                ls2 = gp2.length() - i2;
            }
        }
        List<Instruction> instructions1 = gp1.getInstructions();
        List<Instruction> instructions2 = gp2.getInstructions();
        ArrayList<Instruction> instructions1_1 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions1_2 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions1_3 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions2_1 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions2_2 = new ArrayList<Instruction>();
        ArrayList<Instruction> instructions2_3 = new ArrayList<Instruction>();
        for (i = 0; i < i1; ++i) {
            instructions1_1.add(instructions1.get(i));
        }
        for (i = i1; i < i1 + ls1; ++i) {
            instructions1_2.add(instructions1.get(i));
        }
        for (i = i1 + ls1; i < instructions1.size(); ++i) {
            instructions1_3.add(instructions1.get(i));
        }
        for (i = 0; i < i2; ++i) {
            instructions2_1.add(instructions2.get(i));
        }
        for (i = i2; i < i2 + ls2; ++i) {
            instructions2_2.add(instructions2.get(i));
        }
        for (i = i2 + ls2; i < instructions2.size(); ++i) {
            instructions2_3.add(instructions2.get(i));
        }
        instructions1.clear();
        instructions2.clear();
        for (i = 0; i < i1; ++i) {
            instructions1.add((Instruction)instructions1_1.get(i));
        }
        for (i = 0; i < ls2; ++i) {
            instructions1.add(InstructionHelper.reassign2Program((Instruction)instructions2_2.get(i), gp1));
        }
        for (i = 0; i < instructions1_3.size(); ++i) {
            instructions1.add((Instruction)instructions1_3.get(i));
        }
        for (i = 0; i < i2; ++i) {
            instructions2.add((Instruction)instructions2_1.get(i));
        }
        for (i = 0; i < ls1; ++i) {
            instructions2.add(InstructionHelper.reassign2Program((Instruction)instructions1_2.get(i), gp2));
        }
        for (i = 0; i < instructions2_3.size(); ++i) {
            instructions2.add((Instruction)instructions2_3.get(i));
        }
        gp1.invalidateCost();
        gp2.invalidateCost();
    }
}

