/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp;

import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.services.SimpleRandEngine;
import com.github.chen0040.gp.treegp.enums.TGPCrossoverStrategy;
import com.github.chen0040.gp.treegp.enums.TGPInitializationStrategy;
import com.github.chen0040.gp.treegp.enums.TGPMutationStrategy;
import com.github.chen0040.gp.treegp.enums.TGPPopulationReplacementStrategy;
import com.github.chen0040.gp.treegp.gp.Population;
import com.github.chen0040.gp.treegp.program.OperatorSet;
import com.github.chen0040.gp.treegp.program.Solution;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

public class TreeGP {
    private TGPInitializationStrategy populationInitializationStrategy = TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_GROW;
    private TGPCrossoverStrategy crossoverStrategy = TGPCrossoverStrategy.CROSSOVER_SUBTREE_BIAS;
    private TGPMutationStrategy mutationStrategy = TGPMutationStrategy.MUTATION_SUBTREE;
    private TGPPopulationReplacementStrategy replacementStrategy = TGPPopulationReplacementStrategy.MuPlusLambda;
    private RandEngine randEngine = new SimpleRandEngine();
    private int maxDepthForCrossover = 7;
    private int maxProgramDepth = 7;
    private int maxDepthForCreation = 7;
    private double macroMutationRate = 0.25;
    private double microMutationRate = 0.25;
    private double crossoverRate = 0.5;
    private double reproductionRate = 0.0;
    private double elitismRatio;
    private double epsilon = 1.0E-9;
    private int populationSize = 1000;
    private int maxGeneration = 1000;
    private int variableCount;
    private OperatorSet operatorSet = new OperatorSet();
    private List<Double> constants = new ArrayList<Double>();
    private List<Double> constantWeights = new ArrayList<Double>();
    private List<Observation> observations = new ArrayList<Observation>();
    private BiFunction<Solution, List<Observation>, Double> costEvaluator;

    public int getTreeCountPerSolution() {
        return this.observations.get(0).outputCount();
    }

    public double constantWeight(int index) {
        if (index >= this.constantWeights.size()) {
            return 1.0;
        }
        return this.constantWeights.get(index);
    }

    public double constant(int index) {
        return this.constants.get(index);
    }

    public double evaluateCost(Solution solution) {
        if (this.costEvaluator != null) {
            return this.costEvaluator.apply(solution.makeCopy(), this.observations);
        }
        throw new RuntimeException("Cost evaluator for the linear program is not specified!");
    }

    public Population newPopulation() {
        return new Population(this);
    }

    public void addConstant(double constant, double weight) {
        this.constants.add(constant);
        this.constantWeights.add(weight);
    }

    public void addConstants(double ... constants) {
        for (int i = 0; i < constants.length; ++i) {
            this.addConstant(constants[0], 1.0);
        }
    }

    public TGPInitializationStrategy getPopulationInitializationStrategy() {
        return this.populationInitializationStrategy;
    }

    public TGPCrossoverStrategy getCrossoverStrategy() {
        return this.crossoverStrategy;
    }

    public TGPMutationStrategy getMutationStrategy() {
        return this.mutationStrategy;
    }

    public TGPPopulationReplacementStrategy getReplacementStrategy() {
        return this.replacementStrategy;
    }

    public RandEngine getRandEngine() {
        return this.randEngine;
    }

    public int getMaxDepthForCrossover() {
        return this.maxDepthForCrossover;
    }

    public int getMaxProgramDepth() {
        return this.maxProgramDepth;
    }

    public int getMaxDepthForCreation() {
        return this.maxDepthForCreation;
    }

    public double getMacroMutationRate() {
        return this.macroMutationRate;
    }

    public double getMicroMutationRate() {
        return this.microMutationRate;
    }

    public double getCrossoverRate() {
        return this.crossoverRate;
    }

    public double getReproductionRate() {
        return this.reproductionRate;
    }

    public double getElitismRatio() {
        return this.elitismRatio;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public int getMaxGeneration() {
        return this.maxGeneration;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public OperatorSet getOperatorSet() {
        return this.operatorSet;
    }

    public List<Double> getConstants() {
        return this.constants;
    }

    public List<Double> getConstantWeights() {
        return this.constantWeights;
    }

    public List<Observation> getObservations() {
        return this.observations;
    }

    public BiFunction<Solution, List<Observation>, Double> getCostEvaluator() {
        return this.costEvaluator;
    }

    public void setPopulationInitializationStrategy(TGPInitializationStrategy populationInitializationStrategy) {
        this.populationInitializationStrategy = populationInitializationStrategy;
    }

    public void setCrossoverStrategy(TGPCrossoverStrategy crossoverStrategy) {
        this.crossoverStrategy = crossoverStrategy;
    }

    public void setMutationStrategy(TGPMutationStrategy mutationStrategy) {
        this.mutationStrategy = mutationStrategy;
    }

    public void setReplacementStrategy(TGPPopulationReplacementStrategy replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
    }

    public void setRandEngine(RandEngine randEngine) {
        this.randEngine = randEngine;
    }

    public void setMaxDepthForCrossover(int maxDepthForCrossover) {
        this.maxDepthForCrossover = maxDepthForCrossover;
    }

    public void setMaxProgramDepth(int maxProgramDepth) {
        this.maxProgramDepth = maxProgramDepth;
    }

    public void setMaxDepthForCreation(int maxDepthForCreation) {
        this.maxDepthForCreation = maxDepthForCreation;
    }

    public void setMacroMutationRate(double macroMutationRate) {
        this.macroMutationRate = macroMutationRate;
    }

    public void setMicroMutationRate(double microMutationRate) {
        this.microMutationRate = microMutationRate;
    }

    public void setCrossoverRate(double crossoverRate) {
        this.crossoverRate = crossoverRate;
    }

    public void setReproductionRate(double reproductionRate) {
        this.reproductionRate = reproductionRate;
    }

    public void setElitismRatio(double elitismRatio) {
        this.elitismRatio = elitismRatio;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public void setPopulationSize(int populationSize) {
        this.populationSize = populationSize;
    }

    public void setMaxGeneration(int maxGeneration) {
        this.maxGeneration = maxGeneration;
    }

    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    public void setOperatorSet(OperatorSet operatorSet) {
        this.operatorSet = operatorSet;
    }

    public void setObservations(List<Observation> observations) {
        this.observations = observations;
    }

    public void setCostEvaluator(BiFunction<Solution, List<Observation>, Double> costEvaluator) {
        this.costEvaluator = costEvaluator;
    }
}

